package com.siguiente.fasal.order

import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.OrderItemDesignBinding
import com.siguiente.fasal.home.model.RequestSampleModel
import com.siguiente.fasal.utils.BaseRecyclerViewAdapter


class OrderAdapter : BaseRecyclerViewAdapter<RequestSampleModel, OrderItemDesignBinding>() {
    override fun getLayout() = R.layout.order_item_design

    override fun onBindViewHolder(
        holder: Companion.BaseViewHolder<OrderItemDesignBinding>,
        position: Int
    ) {
        holder.binding.requestModel = items[position]
        holder.binding.root.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }

    }

}