package com.siguiente.fasal.profile

import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.view.View
import android.widget.ImageView
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ActivityChangePasswordBinding
import com.siguiente.fasal.dialog.MessageDialog
import com.siguiente.fasal.login.ui.login.LoginActivity
import com.siguiente.fasal.utils.PreferenceProvider
import com.siguiente.fasal.utils.toast
import kotlinx.android.synthetic.main.activity_change_password.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance

class ChangePasswordActivity : AppCompatActivity(), KodeinAware {
    override val kodein by kodein()
    private lateinit var viewModel: ProfileViewModel
    val factory: ProfileViewModelFactory by instance()
    val provider: PreferenceProvider by instance()

    var activityType = ""

    lateinit var binding: ActivityChangePasswordBinding
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_change_password)
        supportActionBar?.hide()

        activityType = intent.extras!!.getString("ActivityType", "")
        viewModel = ViewModelProvider(this, factory).get(ProfileViewModel::class.java)

        if (activityType.equals("Reset")) {
            resetPasswordLayout.visibility = View.VISIBLE
            changePasswordLayout.visibility = View.GONE
            titleChangePasswordTV.text = "Reset Password"
        } else {
            resetPasswordLayout.visibility = View.GONE
            changePasswordLayout.visibility = View.VISIBLE
            titleChangePasswordTV.text = "Change Password"
        }

        viewModel.changePasswordResult.observe(this, Observer {
            val messageDialog = MessageDialog(it.message.toString())
            messageDialog.show(supportFragmentManager, "Message")
            oldPassword.setText("")
            newPassword.setText("")
        })

        viewModel.resetPasswordResult.observe(this, Observer {
            if (!it.error!!) {
                toast(it.message!!)
                startActivity(Intent(this, LoginActivity::class.java))
            }
        })

        changePasswordBackIV.setOnClickListener {
            onBackPressed()
        }

        changePasswordButton.setOnClickListener {
            if (!oldPassword.text.isNullOrEmpty()) {
                changePassword()
            } else {
                oldPassword.setError("Enter Valid Password")
            }
        }

        resetPasswordButton.setOnClickListener {
            if (!resetNewPassword.text.isNullOrEmpty()) {
                resetPassword()
            } else {
                resetNewPassword.setError("Enter Valid Password")
            }
        }


    }

    fun changePassword() {
        val map: java.util.HashMap<String, String> = java.util.HashMap()
        val userID = provider.getValueByKey("userID")
        val oldPassword = binding.oldPassword.text.toString().trim()
        val newPassword = binding.newPassword.text.toString().trim()

        map.put("userID", userID!!)
        map.put("oldPassword", oldPassword)
        map.put("newPassword", newPassword)
        viewModel.changePassword(map)
    }

    fun resetPassword() {
        val map: java.util.HashMap<String, String> = java.util.HashMap()
        val userID = provider.getValueByKey("forgotUserID")
        val password = binding.resetNewPassword.text.toString().trim()
        val confirmPassword = binding.resetConfirmPassword.text.toString().trim()

        if (password.equals(confirmPassword)) {
            map.put("userID", userID!!)
            map.put("newPassword", password)
            viewModel.resetPassword(map)
        } else {
            val messageDialog = MessageDialog("Password missmatch please enter same password")
            messageDialog.show(supportFragmentManager, "Message")
        }
    }
}