package com.siguiente.fasal.profile

import android.os.Bundle
import android.view.View
import android.widget.Spinner
import androidx.appcompat.app.AppCompatActivity
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ActivityEditProfileBinding
import com.siguiente.fasal.dialog.MessageDialog
import com.siguiente.fasal.utils.PreferenceProvider
import com.siguiente.fasal.utils.toast
import kotlinx.android.synthetic.main.activity_edit_profile.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance


class EditProfileActivity : AppCompatActivity(), KodeinAware {
    lateinit var binding: ActivityEditProfileBinding
    override val kodein by kodein()
    private lateinit var viewModel: ProfileViewModel
    val factory: ProfileViewModelFactory by instance()
    val provider: PreferenceProvider by instance()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_edit_profile)
        supportActionBar?.hide()
        profileProgressBar.visibility = View.VISIBLE

        viewModel = ViewModelProvider(this, factory).get(ProfileViewModel::class.java)
        binding.profileViewModel = viewModel
        binding.lifecycleOwner = this

        val userID = provider.getValueByKey("userID")!!
        val userType = provider.getValueByKey("userType")!!
        val map: HashMap<String, String> = HashMap()
        map.put("userID", userID)
        map.put("userType", userType)
        viewModel.getUserProfile(map)

        viewModel.profileResult.observe(this, Observer {
            val msgDialog = MessageDialog(it.message.toString())
            msgDialog.show(supportFragmentManager, "MessageDialog")
            profileProgressBar.visibility = View.INVISIBLE
        })

        viewModel.profileData.observe(this, Observer {
            if (it.gender.toString().equals("M")) {
                epGenderSpinner.setSelection(1)
            } else if (it.gender.toString().equals("F")) {
                epGenderSpinner.setSelection(2)
            } else {
                epGenderSpinner.setSelection(0)
            }

            epStateSpinner.setSelection(getIndex(epStateSpinner, it.state.toString()))
            profileProgressBar.visibility = View.INVISIBLE
        })


        epBackIV.setOnClickListener {
            onBackPressed()
        }


        updateProfileButton.setOnClickListener {
            profileProgressBar.visibility = View.VISIBLE
            updateProfile()
        }
    }

    private fun getIndex(spinner: Spinner, myString: String): Int {
        for (i in 0 until spinner.count) {
            if (spinner.getItemAtPosition(i).toString().equals(myString, ignoreCase = true)) {
                return i
            }
        }
        return 0
    }


    fun updateProfile() {
        val map: java.util.HashMap<String, String> = java.util.HashMap()
        val userID = provider.getValueByKey("userID")
        val name = binding.epNameET.text.toString().trim()
        val mobile = binding.epMobileET.text.toString().trim()
        val age = binding.epAgeET.text.toString().trim()
        val gender = binding.epGenderSpinner.selectedItem.toString().trim()
        var genderChar = ""
        if (gender.equals("M"))
            genderChar = "M"
        else
            genderChar = "F"
        val address = binding.epAddressET.text.toString().trim()
        val city = binding.epCityET.text.toString().trim()
        val district = binding.epDistrictET.text.toString().trim()
        val pinCode = binding.epPincodeET.text.toString().trim()
        val state = binding.epStateSpinner.selectedItem.toString().trim()

        map.put("userID", userID!!)
        map.put("userName", name)
        map.put("userMobile", mobile)
        map.put("age", age)
        map.put("gender", genderChar)
        map.put("userLocation", address)
        map.put("city", city)
        map.put("district", district)
        map.put("pincode", pinCode)
        map.put("state", state)
        viewModel.updateUserProfile(map)
    }
}