package com.siguiente.fasal.profile

import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.view.View
import android.widget.Toast
import androidx.core.view.isVisible
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ActivityForgotPasswordBinding
import com.siguiente.fasal.registration.UserRegistrationViewModel
import com.siguiente.fasal.registration.UserRegistrationViewModelFactory
import com.siguiente.fasal.utils.PreferenceProvider
import kotlinx.android.synthetic.main.activity_forgot_password.*
import kotlinx.android.synthetic.main.activity_user_registration.*
import org.json.JSONObject
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance
import java.util.HashMap

class ForgotPasswordActivity : AppCompatActivity(), KodeinAware {

    override val kodein by kodein()
    lateinit var binding: ActivityForgotPasswordBinding
    private lateinit var viewModel: ProfileViewModel
    val factory: ProfileViewModelFactory by instance()

    private lateinit var viewModelUser: UserRegistrationViewModel
    private val factoryUser: UserRegistrationViewModelFactory by instance()


    val provider: PreferenceProvider by instance()
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_forgot_password)

        viewModel = ViewModelProvider(this, factory).get(ProfileViewModel::class.java)
        viewModelUser =
            ViewModelProvider(this, factoryUser).get(UserRegistrationViewModel::class.java)

        viewModel.forgotPasswordResult.observe(this, Observer {
            if (!it.error!!) {
                provider.saveValueByKey("forgotUserID", "" + it.userID)
            }
        })


        viewModelUser.verifyOtpResult.observe(this, Observer {
            Toast.makeText(this, "" + it, Toast.LENGTH_SHORT).show()
            if (it.contains("Successfully")) {
                val intent = Intent(this, ChangePasswordActivity::class.java)
                intent.putExtra("ActivityType", "Reset")
                startActivity(intent)
            } else {
                val intent = Intent(this, ChangePasswordActivity::class.java)
                intent.putExtra("ActivityType", "Reset")
                startActivity(intent)
            }

        })

        forgotPasswordGoButton.setOnClickListener {
            if (binding.forgotPasswordMobileET.text!!.length == 10) {
                forgotPasswordOTPLayout.isVisible = true
                forgotPasswordGoButton.isClickable = false
                forgotPasswordGoButton.isEnabled = false
                forgotPasswordGoButton.setBackgroundColor(resources.getColor(R.color.colorGrayTexts))
                forgotPassword()
            } else {
                forgotPasswordMobileET.error = "Enter valid mobile number"
            }

        }


        forgotPasswordVerifyButton.setOnClickListener {
            if (binding.otpEditTextForgotPass.text.toString().trim().isNotEmpty()) {
                forgotPasswordProgressBar.visibility = View.VISIBLE
                verifyOTP()
            } else {
                otpEditText.error = "Enter OTP"
            }
        }

        forgotPasswordBackIV.setOnClickListener {
            onBackPressed()
        }
    }

    private fun forgotPassword() {
        val mobile = binding.forgotPasswordMobileET.text.toString().trim()
        val map: HashMap<String, String> = HashMap()
        map.put("userMobile", mobile)
        viewModel.forgotPassword(map)
    }

    private fun verifyOTP() {
        val mobile = binding.forgotPasswordMobileET.text.toString().trim()
        val otp = binding.otpEditTextForgotPass.text.toString().trim()
        val map: HashMap<String, Any> = HashMap()
        map["userMobile"] = mobile
        map["OTP"] = otp.toInt()
        viewModelUser.verifyOTP(map)
    }

}