package com.siguiente.fasal.profile

import android.app.Activity
import android.app.Dialog
import android.content.DialogInterface.OnShowListener
import android.content.Intent
import android.graphics.Bitmap
import android.os.Build
import android.os.Bundle
import android.util.DisplayMetrics
import android.util.Log
import android.util.TypedValue
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import androidx.annotation.RequiresApi
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.ViewModelProvider
import com.google.android.material.bottomsheet.BottomSheetBehavior
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.siguiente.fasal.R
import com.siguiente.fasal.account.MyAccountActivity
import com.siguiente.fasal.databinding.FragmentProfileBinding
import com.siguiente.fasal.help.SupportActivity
import com.siguiente.fasal.kyc.KycDetailsActivity
import com.siguiente.fasal.utils.createImage
import kotlinx.android.synthetic.main.fragment_profile.*


class ProfileFragment : BottomSheetDialogFragment() {

    private lateinit var profileViewModel: ProfileViewModel
    lateinit var binding: FragmentProfileBinding

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding = DataBindingUtil.inflate(inflater, R.layout.fragment_profile, container, false)

        return binding.root
    }

    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
        val dialog: Dialog = super.onCreateDialog(savedInstanceState)
        dialog.setOnShowListener(OnShowListener { dialogInterface ->
            val bottomSheetDialog = dialogInterface as BottomSheetDialog
            setupFullHeight(bottomSheetDialog)
        })
        return dialog
    }


    private fun setupFullHeight(bottomSheetDialog: BottomSheetDialog) {
        val bottomSheet =
            bottomSheetDialog.findViewById<View>(R.id.design_bottom_sheet) as FrameLayout?
        val behavior: BottomSheetBehavior<*> = BottomSheetBehavior.from<FrameLayout?>(bottomSheet!!)
        val layoutParams = bottomSheet.layoutParams
        val windowHeight = getWindowHeight()
        if (layoutParams != null) {
            layoutParams.height = windowHeight
        }
        bottomSheet.layoutParams = layoutParams
        behavior.state = BottomSheetBehavior.STATE_EXPANDED
    }

    private fun getWindowHeight(): Int {
        val displayMetrics = DisplayMetrics()
        (context as Activity?)!!.windowManager.defaultDisplay.getMetrics(displayMetrics)

        return displayMetrics.heightPixels
    }

    @RequiresApi(Build.VERSION_CODES.M)
    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        profileViewModel = ViewModelProvider(this).get(ProfileViewModel::class.java)


        profileEditButton.setOnClickListener {
            startActivity(Intent(context, EditProfileActivity::class.java))
        }
        profileMyAccountLL.setOnClickListener {
            startActivity(Intent(context, MyAccountActivity::class.java))
        }
        profileKYCDetailsLL.setOnClickListener {
            startActivity(Intent(context, KycDetailsActivity::class.java))
        }
        profileChangedPasswordLL.setOnClickListener {
            startActivity(Intent(context, ChangePasswordActivity::class.java))
        }

        profileSupportLL.setOnClickListener {
            startActivity(Intent(context, SupportActivity::class.java))
        }

        storeMyAccountLL.setOnClickListener{

        }

        crossProfileIV.setOnClickListener {
            this.dismiss()
        }

        val bitmap: Bitmap = createImage(
            100,
            100,
            resources.getColor(R.color.colorPrimary),
            resources.getColor(R.color.colorWhite),
            "A"
        )!!
        circulerProfileIVP.setImageBitmap(bitmap)

    }



}