package com.siguiente.fasal.profile

import com.siguiente.fasal.network.MyApi
import com.siguiente.fasal.network.SafeApiRequest
import com.siguiente.fasal.network.response.CommonResponse
import com.siguiente.fasal.network.response.ProfileResponse

class ProfileRepository(
    val api: MyApi
) : SafeApiRequest() {


    suspend fun getUserProfile(field:Map<String,String>):ProfileResponse{
        return apiRequest { api.getUserProfile(field) }
    }

    suspend fun updateUserProfile(field:Map<String,String>):CommonResponse{
        return apiRequest { api.updateUserProfile(field) }
    }

    suspend fun changePassword(field:Map<String,String>):CommonResponse{
        return apiRequest { api.changePassword(field) }
    }

    suspend fun forgotPassword(field:Map<String,String>):CommonResponse{
        return apiRequest { api.forgotPassword(field) }
    }

    suspend fun resetPassword(field:Map<String,String>):CommonResponse{
        return apiRequest { api.resetPassword(field) }
    }

    suspend fun uploadPhoto(field:Map<String,String>):CommonResponse{
        return apiRequest { api.saveProfilePhoto(field) }
    }


}