package com.siguiente.fasal.profile

import android.util.Log
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.siguiente.fasal.network.response.CommonResponse
import com.siguiente.fasal.network.response.ProfileResponse
import com.siguiente.fasal.utils.ApiException
import com.siguiente.fasal.utils.Coroutines
import com.siguiente.fasal.utils.NoInternetException

class ProfileViewModel(
    var repository: ProfileRepository
) : ViewModel() {

    var profileData = MutableLiveData<ProfileResponse>()
    var uploadPhotoResult = MutableLiveData<CommonResponse>()
    var profileResult = MutableLiveData<CommonResponse>()
    var changePasswordResult = MutableLiveData<CommonResponse>()
    var forgotPasswordResult = MutableLiveData<CommonResponse>()
    var resetPasswordResult = MutableLiveData<CommonResponse>()


    fun getUserProfile(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.getUserProfile(field)
                Log.e("GetProfile s -", "" + response.toString())
                if (response.error != true) {
                    profileData.value = response
                } else {
                    profileData.value = response
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }


    fun updateUserProfile(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.updateUserProfile(field)
                if (response.error != true) {
                    profileResult.value = response
                    Log.e("updateProfile s -", "" + response.toString())
                } else {
                    profileResult.value = response
                    Log.e("updateProfile e-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }


    fun changePassword(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.changePassword(field)
                changePasswordResult.value = response
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun forgotPassword(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.forgotPassword(field)
                forgotPasswordResult.value = response
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun resetPassword(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.resetPassword(field)
                resetPasswordResult.value = response
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }


    fun uploadPhoto(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.uploadPhoto(field)
                uploadPhotoResult.value = response
                Log.e("UploadPhotoRes-",""+response)
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }
}