package com.siguiente.fasal.registration

import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.view.View
import android.widget.RadioButton
import android.widget.RadioGroup
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.siguiente.fasal.MainActivity
import com.siguiente.fasal.R
import com.siguiente.fasal.custom_view.MultiSelectSpinner
import com.siguiente.fasal.databinding.ActivityRegistrationBinding
import com.siguiente.fasal.utils.PreferenceProvider
import com.siguiente.fasal.utils.toast
import kotlinx.android.synthetic.main.activity_registration.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance
import java.util.*
import kotlin.collections.ArrayList


class RegistrationActivity : AppCompatActivity(), KodeinAware, RadioGroup.OnCheckedChangeListener,
    MultiSelectSpinner.OnMultipleItemsSelectedListener {

    override val kodein by kodein()
    private lateinit var binding: ActivityRegistrationBinding
    private var userMobile = ""
    private var userType = ""
    private var selectedShopType = ""
    private lateinit var viewModel: UserRegistrationViewModel
    private val factory: UserRegistrationViewModelFactory by instance()
    val provider: PreferenceProvider by instance()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_registration)
        supportActionBar?.hide()
        userMobile = intent.extras!!.getString("UserMobile", "")
        registrationRadioGroup.setOnCheckedChangeListener(this)

        viewModel = ViewModelProvider(this, factory).get(
            UserRegistrationViewModel::class.java
        )
        binding.viewModel = viewModel

        getShopTypeList()




        viewModel.registrationResult.observe(this, Observer {
            registerProgressBar.visibility = View.GONE
            if (!it.error!!) {
                provider.saveValueByKey("userID", it.userID.toString())
                provider.saveValueByKey("userType", "" + it.userType)
                val intent = Intent(applicationContext, MainActivity::class.java)
                intent.putExtra("ActivityTag", "Registration")
                startActivity(intent)
                this.finish()
                Toast.makeText(this, "" + it.message, Toast.LENGTH_SHORT).show()
            } else {
                Toast.makeText(this, "" + it.message, Toast.LENGTH_SHORT).show()
            }

        })

        viewModel.shopTypeResult.observe(this, Observer { it ->
            val arrayList = ArrayList<String>()
            if (!it.error) {
                it.data.forEach {
                    arrayList.add(it.shopType)
                }
                arrayList.add(0, "None")
                shopTypeSpinner.setItems(arrayList)
                shopTypeSpinner.hasNoneOption(true)
                shopTypeSpinner.setSelection(intArrayOf(0))
                shopTypeSpinner.setListener(this)

                Log.e("ArrayList-", "" + arrayList)
            }
        })


        registrationBackIV.setOnClickListener {
            onBackPressed()
        }

        registrationButton.setOnClickListener {
            var error = false

            if (registrationNameET.text.isNullOrEmpty()) {
                registrationNameET.error = "Enter Name"
                error = true
            }

            if (registrationPasswordET.text.isNullOrEmpty()) {
                registrationPasswordET.error = "Enter password"
                error = true
            }

            if (registrationConfirmPasswordET.text.isNullOrEmpty()) {
                registrationConfirmPasswordET.error = "Enter confirm password"
                error = true
            }

            if (registrationPasswordET.text.toString() != registrationConfirmPasswordET.text.toString()
            ) {
                registrationConfirmPasswordET.error = "Password mismatch"
                error = true
            }

            val shopState = binding.shopStateSpinner.selectedItem.toString().trim()
            if (shopState == "Select state") {
                toast("Please Select state")
                error = true
            }

            if (userType == "Shop") {

                if (shopNameET.text.isNullOrEmpty()) {
                    shopNameET.error = "Enter Shop name"
                    error = true
                }

                if (shopAddressET.text.isNullOrEmpty()) {
                    shopAddressET.error = "Enter Shop address"
                    error = true
                }

                if (shopDistrictET.text.isNullOrEmpty()) {
                    shopDistrictET.error = "Enter District"
                    error = true
                }
            }

            if (!error) {
                registerProgressBar.visibility = View.VISIBLE
                register()

            } else {
                Log.e("register-", "else")
            }
        }


    }

    private fun register() {
        var userTypeData = 0
        val name = binding.registrationNameET.text.toString().trim()
        val confirmPassword = binding.registrationConfirmPasswordET.text.toString().trim()
        val shopName = binding.shopNameET.text.toString().trim()
        val shopAddress = binding.shopAddressET.text.toString().trim()
        val shopDistrict = binding.shopDistrictET.text.toString().trim()
        val shopState = binding.shopStateSpinner.selectedItem.toString().trim()

        userTypeData = when (userType) {
            "Farmer" -> 1
            "Shop" -> 2
            else -> 3
        }

        val map: HashMap<String, String> = HashMap()
        map["userName"] = name
        map["userMobile"] = userMobile
        map["useremail"] = ""
        map["userType"] = userTypeData.toString()
        map["userPassword"] = confirmPassword
        map["shopName"] = shopName
        map["shopType"] = selectedShopType
        map["shopAddress"] = shopAddress
        map["district"] = shopDistrict
        map["state"] = shopState
        viewModel.registerUser(map)
    }

    private fun getShopTypeList() {
        viewModel.getShopTypeList()
    }

    override fun onCheckedChanged(group: RadioGroup?, checkedId: Int) {
        val checkedRadioButton = group?.findViewById(group.checkedRadioButtonId) as? RadioButton
        checkedRadioButton.let {

            if (checkedRadioButton!!.isChecked) {
                userType = checkedRadioButton.text.toString()
                if (checkedRadioButton.text.equals("Shop")) {
                    shopRegistrationLayout.visibility = View.VISIBLE
                } else {
                    shopRegistrationLayout.visibility = View.GONE
                }
            }

        }
    }

    override fun selectedIndices(indices: List<Int?>?) {
        Log.e("Indices-", "" + indices)
    }

    override fun selectedStrings(strings: List<String?>?) {
        selectedShopType = strings.toString().replace("[", "").replace("]", "").trim()

    }


}