package com.siguiente.fasal.registration

import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import com.siguiente.fasal.network.MyApi
import com.siguiente.fasal.network.response.CommonResponse
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.util.regex.Pattern


class RegistrationRepository {
    private val api:MyApi= TODO()

    fun validateRegistrationField(emailID:String,password:String): LiveData<String> {
        val loginErrorMessage = MutableLiveData<String>()
        if(isEmailValid(emailID)){
            if(password.length<8 && !isPasswordValid(password)){
                loginErrorMessage.value = "Invalid Password"
            }else{
                loginErrorMessage.value = "Successful Login"
            }
        }else{
            loginErrorMessage.value = "Invalid Email"
        }

        return  loginErrorMessage
    }

   /* fun userRegistration(filedName: Map<String, String>): LiveData<CommonResponse> {
        val data = MutableLiveData<CommonResponse>()
        api.userRegistration(filedName).enqueue(object : Callback<CommonResponse> {
            override fun onResponse(call: Call<CommonResponse>, response: Response<CommonResponse>) {
                data.value = response.body()
            }
            // Error case is left out for brevity.
            override fun onFailure(call: Call<CommonResponse>, t: Throwable) {
                TODO()
            }
        })
        return data
    }*/


    fun isEmailValid(email: String): Boolean {
        val expression = "^[\\w\\.-]+@([\\w\\-]+\\.)+[A-Z]{2,4}$"
        val pattern = Pattern.compile(expression, Pattern.CASE_INSENSITIVE)
        val matcher = pattern.matcher(email)
        return matcher.matches()
    }

    fun isPasswordValid(password: String): Boolean{
        val expression  ="^(?=.*[0-9])(?=.*[A-Z])(?=.*[@#\$%^&+=!])(?=\\\\S+\$).{4,}\$";
        val pattern = Pattern.compile(expression, Pattern.CASE_INSENSITIVE)
        val matcher = pattern.matcher(password)
        return matcher.matches()
    }


}