package com.siguiente.fasal.registration

import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.view.View
import android.widget.Toast
import androidx.core.view.isVisible
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ActivityUserRegistrationBinding
import kotlinx.android.synthetic.main.activity_user_registration.*
import kotlinx.android.synthetic.main.bank_details_fragment.*
import org.json.JSONObject
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance
import java.util.HashMap

class UserRegistrationActivity : AppCompatActivity(), KodeinAware {

    private lateinit var binding: ActivityUserRegistrationBinding
    private lateinit var viewModel: UserRegistrationViewModel
    private val factory: UserRegistrationViewModelFactory by instance()

    override val kodein by kodein()


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_user_registration)
        viewModel = ViewModelProvider(this, factory).get(
            UserRegistrationViewModel::class.java
        )


        viewModel.result.observe(this, Observer {
            Toast.makeText(this, "" + it, Toast.LENGTH_SHORT).show()
            if (!it.toString().contains("exist")) {
                userRegistrationOTPLayout.isVisible = true
                userRegistrationGoButton.isClickable = false
                userRegistrationGoButton.isEnabled = false
                userRegistrationGoButton.setBackgroundColor(resources.getColor(R.color.colorGrayTexts))
            }
        })


        viewModel.verifyOtpResult.observe(this, Observer {
            userRegProgressBar.visibility = View.GONE
            Toast.makeText(this, "" + it, Toast.LENGTH_SHORT).show()
            if (it.contains("Successfully")) {
                val intent = Intent(this, RegistrationActivity::class.java)
                intent.putExtra("UserMobile", binding.registrationMobileET.text.toString())
                startActivity(intent)
            }

        })

        userRegistrationGoButton.setOnClickListener {
            if (binding.registrationMobileET.text!!.length == 10) {
                userSignup()
            }else{
                registrationMobileET.error = "Enter valid mobile number"
            }

        }


        userRegistrationVerifyButton.setOnClickListener {
            if (!binding.otpEditText.text.toString().trim().isEmpty()) {
                userRegProgressBar.visibility = View.VISIBLE
                verifyOTP()
            }else{
                otpEditText.error = "Enter OTP"
            }
        }

        userRegistrationBackIV.setOnClickListener {
            onBackPressed()
        }
    }

    private fun verifyOTP() {
        val mobile = binding.registrationMobileET.text.toString().trim()
        val otp = binding.otpEditText.text.toString().trim()
        val map: HashMap<String, Any> = HashMap()
        map["userMobile"] = mobile
        map["OTP"] = otp.toInt()
        viewModel.verifyOTP(map)
    }

    private fun userSignup() {
        val mobile = binding.registrationMobileET.text.toString().trim()
        viewModel.sendOTP(mobile)
    }

}


