package com.siguiente.fasal.registration


import com.siguiente.fasal.network.MyApi
import com.siguiente.fasal.network.SafeApiRequest
import com.siguiente.fasal.network.response.CommonResponse
import com.siguiente.fasal.network.response.DistrictResponse
import com.siguiente.fasal.network.response.ShopTypeResponse
import com.siguiente.fasal.network.response.VerifyMobileResponse
import org.json.JSONObject


class UserRegistrationRepository(
    private val api: MyApi
) : SafeApiRequest() {

    suspend fun sendOTP(filed: Map<String, String>): VerifyMobileResponse {
        return apiRequest { api.verifyMobile(filed) }
    }

    suspend fun verifyOTP(filed: Map<String,Any>): CommonResponse {
        return apiRequest { api.verifyOTP(filed) }
    }

    suspend fun userRegister(filed: Map<String, String>): CommonResponse {
        return apiRequest { api.userRegistration(filed) }
    }
    suspend fun getShopTypeList(): ShopTypeResponse {
        return apiRequest { api.getShopTypeList() }
    }

    suspend fun getDistrictList(filed: Map<String, String>): DistrictResponse {
        return apiRequest { api.getDistrictList(filed) }
    }

}