package com.siguiente.fasal.registration


import android.util.Log
import androidx.databinding.ObservableArrayList
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.siguiente.fasal.network.response.CommonResponse
import com.siguiente.fasal.network.response.DistrictResponse
import com.siguiente.fasal.network.response.ShopTypeResponse
import com.siguiente.fasal.utils.ApiException
import com.siguiente.fasal.utils.Coroutines
import com.siguiente.fasal.utils.NoInternetException
import org.json.JSONObject
import java.util.HashMap


class UserRegistrationViewModel(
    var repository: UserRegistrationRepository
) : ViewModel() {

    var result = MutableLiveData<String>()
    var verifyOtpResult = MutableLiveData<String>()
    var registrationResult = MutableLiveData<CommonResponse>()
    var shopTypeResult = MutableLiveData<ShopTypeResponse>()
    var districtResult = MutableLiveData<DistrictResponse>()


    //For Registration
    val name: MutableLiveData<String> = MutableLiveData()
    val password: MutableLiveData<String> = MutableLiveData()
    val confirmPassword: MutableLiveData<String> = MutableLiveData()
    val formErrors = ObservableArrayList<FormErrors>()

    //For Sending OTP
    fun sendOTP(mobile: String) {
        Coroutines.main {
            try {
                val response = repository.sendOTP(verifyMobileNumber(mobile))
                if (response.error != true) {
                    result.value = response.message!!
                    Log.e("Response -", "" + response.toString())
                    Log.e("message-", "" + response.toString())
                } else {
                    result.value = response.message!!
                    Log.e("Response-", "" + response.toString())
                    Log.e("message-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }


    //For Verifying OTP
    fun verifyOTP(filed: Map<String, Any>) {
        Coroutines.main {
            try {
                val response = repository.verifyOTP(filed)
                if (response.error != true) {
                    verifyOtpResult.value = response.message!!
                    Log.e("verify OTP s -", "" + response.toString())
                } else {
                    verifyOtpResult.value = response.message!!
                    Log.e("verify OTP e-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    //For Shop Type List
    fun getShopTypeList() {
        Coroutines.main {
            try {
                val response = repository.getShopTypeList()
                if (!response.error) {
                    shopTypeResult.value = response
                    Log.e("ShopTypeList -", "" + response.toString())
                } else {
                    shopTypeResult.value = response
                    Log.e("ShopTypeList -", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    //For DistrictList
    fun getDistrictList(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.getDistrictList(field)
                if (!response.error) {
                    districtResult.value = response
                    Log.e("District List -", "" + response.toString())
                } else {
                    districtResult.value = response
                    Log.e("District List -", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    //For User Registration
    fun registerUser(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.userRegister(field)
                if (response.error != true) {
                    registrationResult.value = response
                    Log.e("verify OTP s -", "" + response.toString())
                } else {
                    registrationResult.value = response
                    Log.e("verify OTP e-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }


    private fun verifyMobileNumber(userMobile: String): Map<String, String> {
        val map: HashMap<String, String> = HashMap()
        map["userMobile"] = userMobile
        return map
    }



    enum class FormErrors {
        MISSING_NAME,
        INVALID_EMAIL,
        INVALID_PASSWORD,
        PASSWORDS_NOT_MATCHING,
    }

}