package com.siguiente.fasal.shop.activity

import android.app.SearchManager
import android.content.Context
import android.content.Intent
import android.content.pm.PackageManager
import android.net.Uri
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.provider.MediaStore
import android.text.Editable
import android.text.TextWatcher
import android.util.Log
import android.view.Menu
import android.view.MenuItem
import android.view.View
import android.widget.EditText
import android.widget.Toast
import androidx.appcompat.widget.PopupMenu
import androidx.appcompat.widget.SearchView
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat
import androidx.core.view.MenuItemCompat
import androidx.core.widget.addTextChangedListener
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.ViewModelProvider
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ActivityShopListBinding
import com.siguiente.fasal.databinding.SortAndFilterLayoutBinding
import com.siguiente.fasal.filter.SortAndFilterBottomsheet
import com.siguiente.fasal.home.HomeViewModel
import com.siguiente.fasal.home.HomeViewModelFactory
import com.siguiente.fasal.shop.adapter.ShopListAdapter
import com.siguiente.fasal.home.model.ShopModel
import com.siguiente.fasal.utils.PreferenceProvider
import com.siguiente.fasal.utils.hideKeyboard
import kotlinx.android.synthetic.main.activity_shop_list.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance
import java.util.HashMap

class ShopListActivity : AppCompatActivity(), KodeinAware, TextWatcher,
    SortAndFilterBottomsheet.FilterDialogDismiss {
    override val kodein by kodein()
    lateinit var binding: ActivityShopListBinding
    private lateinit var homeViewModel: HomeViewModel
    private val factory: HomeViewModelFactory by instance()
    private val provider: PreferenceProvider by instance()
    private lateinit var searchView: SearchView
    private var shortingOrder = ""


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_shop_list)
        homeViewModel = ViewModelProvider(this, factory).get(HomeViewModel::class.java)
        shopListProgressBar.visibility = View.VISIBLE
        val map: HashMap<String, String> = HashMap()
        homeViewModel.getShopLists(map)
        homeViewModel.shopResponse.observe(this, androidx.lifecycle.Observer {
            if (!it.error) {
                initShopRecyclerView(it.data)
                shopItemNotFound.visibility = View.GONE
            } else {
                shopListRecyclerView.adapter = null
                shopItemNotFound.visibility = View.VISIBLE
            }
        })

        shopListBackIV.setOnClickListener {
            onBackPressed()
        }

        searchEditText.addTextChangedListener(this)

        sortingTV.setOnClickListener {

            val popup = PopupMenu(this@ShopListActivity, sortingTV)
            popup.menuInflater.inflate(R.menu.sorting_menu, popup.menu)


            popup.setOnMenuItemClickListener {
                if (it.itemId == R.id.menuSortOrderAtoZ) {
                    shortingOrder = "ASC"
                    shortingShopList()
                    Toast.makeText(applicationContext, "ASC", Toast.LENGTH_SHORT).show()
                } else {
                    shortingOrder = "DESC"
                    shortingShopList()
                    Toast.makeText(applicationContext, "DESC", Toast.LENGTH_SHORT).show()
                }
                true
            }

            popup.show()//showing po
        }
    }

    private fun shortingShopList() {
        val map: HashMap<String, String> = HashMap()
        map["sortType"] = shortingOrder
        homeViewModel.getShopLists(map)

    }

    private fun getFilteredShopList() {
        val shopData = provider.getValueByKey("selectedShopFilterData")
        val districtData = provider.getValueByKey("selectedDistrictFilterData")
        Log.e("FilterShopData", "" + shopData)
        Log.e("FilterDistrictData", "" + districtData)
        val map: HashMap<String, String> = HashMap()
        map["district"] = districtData.toString()
        map["shopType"] = shopData.toString()
        map["sortType"] = shortingOrder
        homeViewModel.getShopLists(map)

    }

    private fun initShopRecyclerView(productsItem: ArrayList<ShopModel>) {
        shopListProgressBar.visibility = View.GONE
        val mAdapter = ShopListAdapter().apply {
            addItems(productsItem)
        }

        shopListRecyclerView.apply {
            setHasFixedSize(true)
            adapter = mAdapter
        }

        mAdapter.listener = { _, _, _ ->

        }

        searchCloseIV.setOnClickListener {
            searchEditText.setText("")
            searchEditText.clearFocus()
            searchCloseIV.visibility = View.GONE
            hideKeyboard(searchCloseIV)
        }

        filterTV.setOnClickListener {
            val filterDialog = SortAndFilterBottomsheet()
            filterDialog.show(supportFragmentManager, "SortAndFilterDialog")
            filterDialog.dismissDialog(this)
        }

    }


    override fun onBackPressed() {
        super.onBackPressed()
        provider.saveValueByKey("selectedShopFilterData", "")
        provider.saveValueByKey("selectedDistrictFilterData", "")
    }


    override fun onRequestPermissionsResult(
        requestCode: Int,
        permissions: Array<out String>,
        grantResults: IntArray
    ) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults)
        when (requestCode) {
            1 ->
                if (grantResults.isNotEmpty() && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    // selectImageDialog(101, 102)
                } else {
                    Toast.makeText(this, "You denied the permission", Toast.LENGTH_SHORT).show()
                }
        }
    }

    override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {

    }

    override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
        if (s!!.isNotEmpty()) {
            searchCloseIV.visibility = View.VISIBLE
        } else {
            searchCloseIV.visibility = View.GONE
        }

    }

    override fun afterTextChanged(s: Editable?) {

    }

    override fun dismiss() {
        getFilteredShopList()
    }
}