package com.siguiente.fasal.shop.adapter

import android.view.View
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ShopItemDesignBinding
import com.siguiente.fasal.home.model.ShopModel
import com.siguiente.fasal.utils.BaseRecyclerViewAdapter

class ShopListAdapter: BaseRecyclerViewAdapter<ShopModel, ShopItemDesignBinding>() {
    override fun getLayout() = R.layout.shop_item_design

    override fun onBindViewHolder(
        holder: Companion.BaseViewHolder<ShopItemDesignBinding>,
        position: Int
    ) {
        holder.binding.shopModel = items[position]
        holder.binding.shopCallButton.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }

        val photo = items[position].photo
        if (photo != null) {
            holder.binding.shopListItemIV.visibility = View.GONE
            holder.binding.shopListImageIV.visibility = View.VISIBLE
        }else{
            holder.binding.shopListItemIV.visibility = View.VISIBLE
            holder.binding.shopListItemIV.text = ""+items[position].shopName.substring(0,1).toUpperCase()
            holder.binding.shopListImageIV.visibility = View.GONE
        }

    }

}