package com.siguiente.fasal.utils

import android.app.Application
import com.quickblox.auth.session.QBSettings
import com.siguiente.fasal.BuildConfig
import com.siguiente.fasal.Policies.PoliciesRepository
import com.siguiente.fasal.Policies.PoliciesViewModelFactory
import com.siguiente.fasal.R
import com.siguiente.fasal.account.PaymentHisViewModelFactory
import com.siguiente.fasal.account.PaymentHistoryRepository
import com.siguiente.fasal.account.TransactionHisViewModelFactory
import com.siguiente.fasal.account.TransactionHistoryRepository
import com.siguiente.fasal.dialog.TransferCreditRepository
import com.siguiente.fasal.dialog.TransferCreditViewModelFactory
import com.siguiente.fasal.help.ServiceRepository
import com.siguiente.fasal.help.ServiceViewModelFactory
import com.siguiente.fasal.home.HomeRepository
import com.siguiente.fasal.home.HomeViewModelFactory
import com.siguiente.fasal.home.RequestRepository
import com.siguiente.fasal.home.RequestViewModelFactory
import com.siguiente.fasal.information.InformationRepository
import com.siguiente.fasal.information.InformationViewModelFactory
import com.siguiente.fasal.kyc.ui.main.BankDetailsViewModelFactory
import com.siguiente.fasal.kyc.ui.main.DocumentViewModelFactory
import com.siguiente.fasal.kyc.ui.main.GstViewModelFactory
import com.siguiente.fasal.kyc.ui.main.KycRepository
import com.siguiente.fasal.login.data.LoginRepository
import com.siguiente.fasal.login.ui.login.LoginViewModelFactory
import com.siguiente.fasal.my_store.StoreRepository
import com.siguiente.fasal.my_store.StoreViewModelFactory
import com.siguiente.fasal.network.MyApi
import com.siguiente.fasal.network.NetworkConnectionInterceptor
import com.siguiente.fasal.network.response.PoliciesResponse
import com.siguiente.fasal.news.StoriesRepository
import com.siguiente.fasal.news.StoriesViewModelFactory
import com.siguiente.fasal.profile.ProfileRepository
import com.siguiente.fasal.profile.ProfileViewModelFactory
import com.siguiente.fasal.registration.UserRegistrationRepository
import com.siguiente.fasal.registration.UserRegistrationViewModelFactory
import org.kodein.di.Kodein
import org.kodein.di.KodeinAware
import org.kodein.di.android.x.androidXModule
import org.kodein.di.generic.bind
import org.kodein.di.generic.instance
import org.kodein.di.generic.provider
import org.kodein.di.generic.singleton

//User default credentials
const val DEFAULT_USER_PASSWORD = "quickblox"

//App credentials
private const val APPLICATION_ID = "88746"
private const val AUTH_KEY = "Qn-3TKyLBWCd-Py"
private const val AUTH_SECRET = "vR8dcXV6jkqF7tt"
private const val ACCOUNT_KEY = "5SntxuqzfTg-AeFSeq8W"

class App : Application(), KodeinAware {

    companion object {
        private lateinit var instance: App

        @Synchronized
        fun getInstance(): App = instance
    }

    override fun onCreate() {
        super.onCreate()
        instance = this
        checkCredentials()
        initCredentials()
    }

    private fun checkCredentials() {
        if (APPLICATION_ID.isEmpty() || AUTH_KEY.isEmpty() || AUTH_SECRET.isEmpty() || ACCOUNT_KEY.isEmpty()) {
            throw AssertionError(getString(R.string.error_qb_credentials_empty))
        }
    }

    private fun initCredentials() {
        QBSettings.getInstance().init(applicationContext, APPLICATION_ID, AUTH_KEY, AUTH_SECRET)
        QBSettings.getInstance().accountKey = ACCOUNT_KEY
    }


    override val kodein = Kodein.lazy {
        import(androidXModule(this@App))

        bind() from singleton { NetworkConnectionInterceptor(instance()) }
        bind() from singleton { MyApi(instance()) }
        bind() from singleton { PreferenceProvider(instance()) }
        // bind() from singleton { AppDatabase(instance()) }
        bind() from singleton { UserRegistrationRepository(instance()) }
        bind() from singleton { LoginRepository(instance()) }
        bind() from singleton { ProfileRepository(instance()) }
        bind() from singleton { HomeRepository(instance()) }
        bind() from singleton { StoriesRepository(instance()) }
        bind() from singleton { StoreRepository(instance()) }
        bind() from singleton { TransferCreditRepository(instance()) }
        bind() from singleton { TransactionHistoryRepository(instance()) }
        bind() from singleton { PaymentHistoryRepository(instance()) }
        bind() from singleton { RequestRepository(instance()) }
        bind() from singleton { KycRepository(instance()) }
        bind() from singleton { InformationRepository(instance()) }
        bind() from singleton { PoliciesRepository(instance()) }
        bind() from singleton { ServiceRepository(instance()) }

        bind() from provider { UserRegistrationViewModelFactory(instance()) }
        bind() from provider { LoginViewModelFactory(instance()) }
        bind() from provider { ProfileViewModelFactory(instance()) }
        bind() from provider { HomeViewModelFactory(instance()) }
        bind() from provider { StoriesViewModelFactory(instance()) }
        bind() from provider { StoreViewModelFactory(instance()) }
        bind() from provider { TransferCreditViewModelFactory(instance()) }
        bind() from provider { TransactionHisViewModelFactory(instance()) }
        bind() from provider { PaymentHisViewModelFactory(instance()) }
        bind() from provider { RequestViewModelFactory(instance()) }
        bind() from provider { BankDetailsViewModelFactory(instance()) }
        bind() from provider { DocumentViewModelFactory(instance()) }
        bind() from provider { GstViewModelFactory(instance()) }
        bind() from provider { InformationViewModelFactory(instance()) }
        bind() from provider { PoliciesViewModelFactory(instance()) }
        bind() from provider { ServiceViewModelFactory(instance()) }

    }

}