package com.siguiente.fasal.utils


import android.view.View
import android.widget.AdapterView
import android.widget.ArrayAdapter
import android.widget.Spinner
import androidx.databinding.InverseBindingListener
import com.siguiente.fasal.R
import com.siguiente.fasal.home.model.CategoryModel
import com.siguiente.fasal.my_store.adapter.CategorySpinnerAdapter
import com.siguiente.fasal.my_store.adapter.SubCategorySpinnerAdapter
import com.siguiente.fasal.my_store.model.SubCategoryModel

object SpinnerExtensions {

    fun Spinner.setSpinnerEntries(entries: ArrayList<CategoryModel>?) {
        if (entries != null) {
            val arrayAdapter = CategorySpinnerAdapter(context, android.R.layout.simple_spinner_item, entries)
            arrayAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
            adapter = arrayAdapter
        }
    }

    fun Spinner.setSubCategory(entries: ArrayList<SubCategoryModel>?) {
        if (entries != null) {
            val arrayAdapter = SubCategorySpinnerAdapter(context, android.R.layout.simple_spinner_item, entries)
            arrayAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
            adapter = arrayAdapter
        }
    }

    fun Spinner.setSpinnerItemSelectedListener(listener: ItemSelectedListener?) {
        onItemSelectedListener = if (listener == null) {
            null
        } else {
            object : AdapterView.OnItemSelectedListener {
                override fun onItemSelected(parent: AdapterView<*>, view: View, position: Int, id: Long) {
                    if (tag != position) {
                        listener.onItemSelected(parent.getItemAtPosition(position) as CategoryModel)
                    }
                }

                override fun onNothingSelected(parent: AdapterView<*>) {}
            }
        }
    }

    fun Spinner.setSubSpinnerItemSelectedListener(listener: ItemSelectedListener?) {
        if (listener == null) {
            onItemSelectedListener = null
        } else {
            onItemSelectedListener = object : AdapterView.OnItemSelectedListener {
                override fun onItemSelected(parent: AdapterView<*>, view: View, position: Int, id: Long) {
                    if (tag != position) {
                        listener.onSubItemSelected(parent.getItemAtPosition(position) as SubCategoryModel)
                    }
                }

                override fun onNothingSelected(parent: AdapterView<*>) {}
            }
        }
    }


    fun Spinner.setSpinnerInverseBindingListener(listener: InverseBindingListener?) {
        onItemSelectedListener = if (listener == null) {
            null
        } else {
            object : AdapterView.OnItemSelectedListener {
                override fun onItemSelected(parent: AdapterView<*>, view: View, position: Int, id: Long) {
                    if (tag != position) {
                        listener.onChange()
                    }
                }

                override fun onNothingSelected(parent: AdapterView<*>) {}
            }
        }
    }

    /**
     * set spinner value
     */
    fun Spinner.setSpinnerValue(value: Any?) {
        if (adapter != null ) {
            val position = (adapter as ArrayAdapter<Any>).getPosition(value)
            setSelection(position, false)
            tag = position
        }
    }

    fun Spinner.getSpinnerValue(): Any? {
        return selectedItem
    }

    interface ItemSelectedListener {
        fun onItemSelected(item: CategoryModel)
        fun onSubItemSelected(item:SubCategoryModel)
    }
}