package com.siguiente.fasal.videos

import android.content.Intent
import android.hardware.Camera
import android.os.Bundle
import android.view.SurfaceHolder
import androidx.appcompat.app.AppCompatActivity
import com.siguiente.fasal.R
import com.siguiente.fasal.utils.RingtoneManager
import kotlinx.android.synthetic.main.activity_incoming_call_screen.*
import java.io.IOException

class IncomingCallScreenActivity : AppCompatActivity(),SurfaceHolder.Callback {
    var callerName = ""
    var callingToken = ""
    private lateinit var ringtoneManager: RingtoneManager
    private var surfaceHolder: SurfaceHolder? = null
    private var camera: Camera? = null


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_incoming_call_screen)
        callerName = intent.extras?.getString("callerName")!!
        callingToken = intent.extras?.getString("callingToken")!!
        remoteUser.text = callerName
        ringtoneManager = RingtoneManager(applicationContext)

        surfaceHolder = incomingCallContainer!!.holder
        surfaceHolder!!.addCallback(this)

        button_accept_call.setOnClickListener {
            val intent = Intent(applicationContext, VideoChatViewActivity::class.java)
            intent.putExtra("callingToken", "" + callingToken)
            startActivity(intent)
            this.finish()
        }

        button_reject_call.setOnClickListener {
            this.finish()
        }

    }

    private fun startCamera() {
        camera = Camera.open(1)
        camera!!.setDisplayOrientation(90)
        try {
            camera!!.setPreviewDisplay(surfaceHolder)
            camera!!.startPreview()
        } catch (e: IOException) {
            e.printStackTrace()
        }

    }
    private fun releaseCamera() {
        camera!!.stopPreview()
        camera!!.release()
        camera = null
    }

    override fun onResume() {
        super.onResume()
        startRingtone()
    }

    override fun onPause() {
        super.onPause()
        stopRingtone()
    }

    private fun startRingtone() {
        ringtoneManager.start(looping = false, vibrate = true)
    }

    private fun stopRingtone() {
        ringtoneManager.stop()
    }

    override fun surfaceCreated(holder: SurfaceHolder) {
        startCamera()
    }

    override fun surfaceChanged(holder: SurfaceHolder, format: Int, width: Int, height: Int) {

    }

    override fun surfaceDestroyed(holder: SurfaceHolder) {
       releaseCamera()
    }

}