<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Contracts\Encryption\DecryptException;
use Facade\Ignition\Exceptions\ViewException;
use Session;
use App\Models\category;
use App\Models\sub_category;

class SubCategoryController extends Controller
{
	// All Sub Category
    function AllSubCategory()
	{
		$sub_category = sub_category::leftJoin('category', function($join) {
				$join->on('sub_category.category_id', '=', 'category.id');
			})
			->where('sub_category.flag','=','1')
			->where('category.status','=','1')
			->get([
			'sub_category.id',
			'category.category_name',
			'sub_category.sub_category_name',
			'sub_category.sub_description',
			'sub_category.status'
			]);
		$page_title = 'Sub Category';
		return view('subcategory',['data'=>$sub_category,'page_title'=>$page_title]);
	}

	// Add Sub Category
    function addSubCategorys()
	{
		$page_title = 'Sub Category';
		$category = category::where('flag','=','1')->where('status','=','1')->get();
		return view('addsubcategory',['data'=>$category,'page_title'=>$page_title]);
	}

    function AddSubCategoryData(Request $req)
	{
		$sub_category = new sub_category;
		$sub_category->category_id=$req->category;
		$sub_category->sub_category_name=$req->name;
		$sub_category->sub_description=$req->description;
 		$sub_category->status=$req->status;
		$sub_category->save();
		$req->session()->flash('success','Add successfully');
		return redirect('subcategory');
	}

	// Update Sub Category
	function UpdateSubCategory($id)
	{
 		$sub_category = sub_category::find($id);
		$category = category::where('flag','=','1')->where('status','=','1')->get();
		$page_title = 'Sub Category';
		return view('updatesubcategory',['category'=>$category,'data'=>$sub_category,'page_title'=>$page_title]);     	
	}

	function Save(Request $req)
	{
 		$sub_category = sub_category::find($req->id);
		$sub_category->category_id=$req->category;
		$sub_category->sub_category_name=$req->name;
		$sub_category->sub_description=$req->description;
 		$sub_category->status=$req->status;
		$sub_category->save();
		$req->session()->flash('success','Update successfully');
		return redirect('subcategory');    	
	}

	// Delete Sub Category
	function DeleteSubCategory(Request $req)
	{
 		$sub_category = sub_category::find($req->id);
 		$sub_category->flag='0';
		$sub_category->save();
		$req->session()->flash('success','Delete successfully');
		return redirect('subcategory');     	
	}

}
