<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\CategoryController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

// Route Admin
Route::get('panel', [AdminController::class,'index']);
Route::post('/admin/login', [AdminController::class,'login']);
Route::get('/admin/dashboard', [AdminController::class,'dashboard']);
Route::get('/admin/profile/{id}',[AdminController::class,'Profile']);
Route::post('/admin/profile',[AdminController::class,'Save']);

// Route Kishan
Route::get('/admin/kishan', [UserController::class,'Kishan']);
Route::get('addkishan',[UserController::class,'addKishan']);
Route::post('addkishan',[UserController::class,'AddKishanData']);
Route::post('deletekishan',[UserController::class,'DeleteKishan']);
Route::get('updatekishan/{id}',[UserController::class,'UpdateKishan']);
Route::post('updatekishan',[UserController::class,'Save']);

// Route Vender
Route::get('/admin/vender', [UserController::class,'Vender']);
Route::get('addvender',[UserController::class,'addVender']);
Route::post('addvender',[UserController::class,'AddVenderData']);
Route::post('deletevender',[UserController::class,'DeleteVender']);
Route::get('updatevender/{id}',[UserController::class,'UpdateVender']);
Route::post('updatevender',[UserController::class,'Save']);

// Route Buyer
Route::get('/admin/buyer', [UserController::class,'Buyer']);
Route::get('addbuyer',[UserController::class,'addBuyer']);
Route::post('addbuyer',[UserController::class,'AddBuyerData']);
Route::post('deletebuyer',[UserController::class,'DeleteBuyer']);
Route::get('updatebuyer/{id}',[UserController::class,'UpdateBuyer']);
Route::post('updatebuyer',[UserController::class,'Save']);

// Route Category
Route::get('/admin/category', [CategoryController::class,'AllCategory']);
Route::get('addcategory',[CategoryController::class,'AddCategory']);
Route::post('addcategory',[CategoryController::class,'AddCategoryData']);
Route::post('activecategory',[CategoryController::class,'ActiveCategory']);
Route::post('deactivecategory',[CategoryController::class,'DeactiveCategory']);
Route::post('deletecategory',[CategoryController::class,'DeleteCategory']);
Route::get('updatecategory/{id}',[CategoryController::class,'UpdateCategory']);
Route::post('updatecategory',[CategoryController::class,'Save']);




//Logout
Route::get('logout',[AdminController::class,'Logout']);

