<?php
// required headers
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
 
// get database connection
include_once '../config/db.php';
 
// instantiate product object
include_once '../objects/function.php';
 
$database = new Database();
$db = $database->connect();
 
$product = new User($db);
 //print_r($db);die;
 
 
 // get posted data
$data = json_decode(file_get_contents("php://input"));
// make sure data is not empty
if(
    !empty($data->userID) && 
	!empty($data->oldPassword) &&
	!empty($data->newPassword)
){
    $product->userID = $data->userID;
    $product->oldPassword = $data->oldPassword;
    $product->newPassword = $data->newPassword;
          
    $data = $product->changePassword();
    if($data){
        http_response_code(200);
        echo json_encode(array("error" => false,"message" => "Password changed successfully."));
    }else{
        http_response_code(200);
        echo json_encode(array("error" => true,"message" => "Old password is invalid."));
    }  
}
else{
    http_response_code(200);
    echo json_encode(array("error" => true,"message" => "Required parameters are missing!"));
}
?>