<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Contracts\Encryption\DecryptException;
use Facade\Ignition\Exceptions\ViewException;
use Session;
use Crypt;

use App\Models\AdminLogin;
use App\Models\category;
use App\Models\subcategory;
use App\Models\seedgrain;
use App\Models\users;
use App\Models\servicerequest;
use App\Models\transactionhistory;
use App\Models\coustomerenquiry;


class AdminController extends Controller
{
    public function index()
    {
        return view('admin.index',['page_title' => 'Login']);
    }

    function login(Request $req)
    {
    	$matchThese = ['user_name' => $req->input('username'), 'type' => $req->input('type')];
    	$user = AdminLogin::where($matchThese)->get();
        $user_count = AdminLogin::where($matchThese)->count();

    	if($user_count == '1' && Crypt::decrypt($user[0]->password)==$req->input('password'))
    	{
   			$req->session()->put('id',$user[0]->id);
   			$req->session()->put('name',$user[0]->name);
			$req->session()->put('photo',$user[0]->img);
   			return redirect(url('/admin/dashboard'));
    	}

    	$req->session()->flash('error', 'Invalid email or password!');
    	return redirect()
    			->back()
    			->withInput();
    }

    public function dashboard()
    {
		$todayservicerequest = servicerequest::where('serviceDate','=',date('Y-m-d'))->where('flag','=','1')->count();
		$assignedservicerequest = servicerequest::where('expertID','!=','0')->where('flag','=','1')->count();
		$unassignedservicerequest = servicerequest::where('expertID','=','0')->where('flag','=','1')->count();
		$requestforcashkishan = transactionhistory::where('paymentFor','=','R')->where('transactionStatus','=','Requested')->where('userID','!=','0')->count();
		$requestforcashvender = transactionhistory::where('paymentFor','=','R')->where('transactionStatus','=','Requested')->where('venderID','!=','0')->count();
		$coustomerenquiry = coustomerenquiry::where('flag','=','1')->where('status','=','Requested')->count();
		$no_of_seeds = seedgrain::where('flag','=','1')->count();

		$kishancount = users::where('userType','=','1')->where('flag','=','1')->count();
		$vendercount = users::where('userType','=','2')->where('flag','=','1')->count();
		$buyercount = users::where('userType','=','3')->where('flag','=','1')->count();
		$expertcount = users::where('userType','=','4')->where('flag','=','1')->count();
		$no_of_category = category::where('flag', '=', '1')->count();
		$no_of_sub_category = subcategory::where('flag', '=', '1')->count();
        return view('admin.dashboard',['todayservicerequest'=>$todayservicerequest,'requestforcashkishan'=>$requestforcashkishan,'requestforcashvender'=>$requestforcashvender,'assignedservicerequest'=>$assignedservicerequest,'unassignedservicerequest'=>$unassignedservicerequest,'kishan'=>$kishancount,'vender'=>$vendercount,'buyer'=>$buyercount,'expert'=>$expertcount,'no_of_seeds'=>$no_of_seeds,'no_of_category'=>$no_of_category,'no_of_sub_category'=>$no_of_sub_category,'coustomerenquiry'=>$coustomerenquiry]);
    }

	
	// Update Profile
    function Profile($id)
	{
		$page_title = 'Profile';
		$data = AdminLogin::find($id);
		return view('admin.profile',['data'=>$data]);
	}

	function Save(Request $req)
	{
		if(request()->photo != null)
		{			
			request()->validate([
			'photo' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
			]);

			$imageName = time().'.'.request()->photo->getClientOriginalExtension();
			request()->photo->move(public_path('images'), $imageName);			
			unlink(public_path('images/'.session()->get('photo')));
			$req->session()->put('photo',$imageName);
		}

 		$admin_tbl = AdminLogin::find($req->id);
		$admin_tbl->name=$req->name;
		$admin_tbl->mobile=$req->mobile;
 		$admin_tbl->email=$req->email;
 		$admin_tbl->address=$req->address;
 		if(!empty($imageName)){ $admin_tbl->img=$imageName; }
		$admin_tbl->save();
		$req->session()->put('name',$req->name);
		$req->session()->flash('success','Update successfully');
		return redirect('/admin/profile/'.$req->id);    	
	}

	// Change Password
    function ChangePassword($id)
	{
		$page_title = 'Change Password';
		return view('admin.changepassword',['adminid'=>$id,'page_title'=>$page_title]);
	}

	function ChangePasswordSave(Request $req)
	{

		if($req->new_password != $req->confirm_password){ $req->session()->flash('error','New and confirm password not match'); return redirect()->back()->withInput();}

 		$admin_tbl = AdminLogin::find($req->id);
		$admin_tbl->password = Crypt::encrypt($req->new_password);
		$admin_tbl->save();
		$req->session()->flash('success','Update successfully');
		return redirect('admin/changepassword/'.$req->id);    	
	}

	// Logout
    function Logout()
	{
		session()->forget('id');
		session()->forget('name');
		session()->forget('error');
		return redirect('/panel');
	}
}
