<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Contracts\Encryption\DecryptException;
use Facade\Ignition\Exceptions\ViewException;
use Session;
use App\Models\banner;

class BannerController extends Controller
{
	// All Category
    function AllBanner()
	{
		$banner = banner::get();
		return view('admin.banner',['data'=>$banner]);
	}

	// Add Category
    function AddBanner()
	{
		return view('admin.addbanner');
	}

    function AddBannerData(Request $req)
	{

		request()->validate(['banner' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:500',]);

		$imageName = time().'.'.request()->banner->getClientOriginalExtension();
		request()->banner->move(public_path('images/banner'), $imageName);			

		$banner = new banner;
		$banner->bannerName=$req->bannerName;
		$banner->bannerImage=$imageName;
 		$banner->orderBy=$req->orderBy;
		$banner->save();
		$req->session()->flash('success','Add successfully');
		return redirect('/admin/banner');
	}

	// Update Category
	function UpdateBanner($id)
	{
 		$banner = banner::where('bannerID','=',$id)->first();
		Session::put('banner_image', $banner->bannerImage);
		return view('admin.updatebanner',['data'=>$banner]);     	
	}

	function Save(Request $req)
	{

		if(request()->banner != null)
		{			
			request()->validate([
			'banner' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:500',
			]);

			$imageName = time().'.'.request()->banner->getClientOriginalExtension();
			request()->banner->move(public_path('images/banner'), $imageName);	
			unlink(public_path('images/banner/'.session()->get('banner_image')));
		}
		
		if(!empty($imageName)){ $image = $imageName; } else { $image = session()->get('banner_image'); }

 		$banner = banner::where('bannerID','=',$req->id)
					->update([			
							"bannerName" => $req->bannerName,
							"bannerImage" => $image,
							"orderBy" => $req->orderBy
							]);
		$req->session()->flash('success','Update successfully');
		return redirect('/admin/banner');    	
	}

	// Delete Category
	function DeleteBanner(Request $req)
	{
		$banner = banner::where('bannerID','=',$req->id)->first();
		Session::put('banner_image', $banner->bannerImage);
 		$banner = banner::where('bannerID','=',$req->id)->delete();
		unlink(public_path('images/banner/'.session()->get('banner_image')));
		$req->session()->flash('success','Delete successfully');
		return redirect('/admin/banner');     	
	}

}
