<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Contracts\Encryption\DecryptException;
use Facade\Ignition\Exceptions\ViewException;
use Session;
use App\Models\category;

class CategoryController extends Controller
{
	// All Category
    function AllCategory()
	{
		$category = category::get();
		return view('admin.category',['data'=>$category]);
	}

	// Add Category
    function AddCategory()
	{
		return view('admin.addcategory');
	}

    function AddCategoryData(Request $req)
	{

		request()->validate(['image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:500',]);

		$imageName = time().'.'.request()->image->getClientOriginalExtension();
		request()->image->move(public_path('images/category'), $imageName);			

		$category = new category;
		$category->categoryName=$req->categoryName;
		$category->categoryImage=$imageName;
 		$category->categoryDescription=$req->categoryDescription;
 		$category->orderBy=$req->orderBy;
		$category->save();
		$req->session()->flash('success','Add successfully');
		return redirect('/admin/category');
	}

	// Update Category
	function UpdateCategory($id)
	{
 		$category = category::where('categoryID','=',$id)->first();
		Session::put('category_image', $category->categoryImage);
		return view('admin.updatecategory',['data'=>$category]);     	
	}

	function Save(Request $req)
	{

		if(request()->image != null)
		{			
			request()->validate([
			'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:500',
			]);

			$imageName = time().'.'.request()->image->getClientOriginalExtension();
			request()->image->move(public_path('images/category'), $imageName);	
			unlink(public_path('images/category/'.session()->get('category_image')));
		}
		
		if(!empty($imageName)){ $image = $imageName; } else { $image = session()->get('category_image'); }

 		$category = category::where('categoryID','=',$req->id)
					->update([			
							"categoryName" => $req->categoryName,
							"categoryImage" => $image,
							"categoryDescription" => $req->categoryDescription,
							"orderBy" => $req->orderBy
							]);
		$req->session()->flash('success','Update successfully');
		return redirect('/admin/category');    	
	}

	// Active Category
	function ActiveCategory(Request $req)
	{
 		$category = category::where('categoryID','=',$req->id)
					->update(["flag" => "1"]);
		$req->session()->flash('success','Active successfully');
		return redirect('/admin/category');     	
	}

	// Deactive Category
	function DeactiveCategory(Request $req)
	{
 		$category = category::where('categoryID','=',$req->id)
					->update(["flag" => "0"]);
		$req->session()->flash('success','Deactive successfully');
		return redirect('/admin/category');     	
	}

	// Delete Category
	function DeleteCategory(Request $req)
	{

 		$category = category::where('categoryID','=',$req->id)->first();
		Session::put('category_image', $category->categoryImage);
 		$category = category::where('categoryID','=',$req->id)->delete();
		unlink(public_path('images/category/'.session()->get('category_image')));
		$req->session()->flash('success','Delete successfully');
		return redirect('/admin/category');     	
	}

}
