<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Contracts\Encryption\DecryptException;
use Facade\Ignition\Exceptions\ViewException;
use Session;
use Crypt;

use App\Models\users;
use App\Models\userkyc;
use App\Models\expertschedule;

class ExpertsController extends Controller
{

	// Expert
    function Experts()
	{
		$user = users::where('flag','=','1')->where('userType','=','4')->get();
		return view('admin.experts',['data'=>$user]);
	}

	// Add Expert
    function addExpert()
	{
		return view('admin.addexpert');
	}

    function AddExpertData(Request $req)
	{

		$passbookPhoto = request()->validate(['passbookPhoto' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:1024',]);
		$kycDocumnetPhoto = request()->validate(['kycDocumnetPhoto' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:1024',]);

		$passbook = time().'.'.request()->passbookPhoto->getClientOriginalExtension();
		request()->passbookPhoto->move(public_path('images/passbook'), $passbook);		

		$kycdoc = time().'.'.request()->kycDocumnetPhoto->getClientOriginalExtension();
		request()->kycDocumnetPhoto->move(public_path('images/kycdoc'), $kycdoc);		

		$users = new users;
		$users->kycStatus='Y';
		$users->kycVerifiedStatus='Verified';
		$users->userName=$req->userName;
		$users->userMobile=$req->userMobile;
		$users->userEmail=$req->userEmail;
		$users->userType='4';
		$users->gender=$req->gender;
		$users->age=$req->age;
		$users->userLocation=$req->userLocation;
 		$users->city=$req->city;
 		$users->district=$req->district;
 		$users->state=$req->state;
 		$users->pincode=$req->pincode;
 		if(!empty($req->userPassword)){$users->userPassword=md5($req->userPassword);}
		$users->save();

		$userkyc = new userkyc;
		$userkyc->userID=$users->id;
		$userkyc->accountNumber=$req->accountNumber;
		$userkyc->accountHolderName=$req->accountHolderName;
		$userkyc->bankName=$req->bankName;
		$userkyc->ifscCode=$req->ifscCode;
		$userkyc->passbookImage=$passbook;
		$userkyc->kycDocumentName=$req->kycDocumentName;
		$userkyc->kycDocumnetImg=$kycdoc;
		$userkyc->save();
		$req->session()->flash('success','Add successfully');
		return redirect('/admin/experts');
	}

	// View Expert
	function ViewExpertDetail($id)
	{
 		$users = users::find($id);
 		$kycdata = userkyc::where('userID','=',$id)->first();
		$schedule = expertschedule::where('expertID','=',$id)->where('flag','=','1')->get();
		return view('/admin/viewexpertdetail',['data'=>$users,'kycdata'=>$kycdata,'schedule'=>$schedule]);     	
	}

	// Update Expert KYC Status
	function UpdateKYCStatus(Request $req)
	{
 		$users = users::find($req->id);
		$users->kycVerifiedStatus=$req->kycVerifiedStatus;
		$users->kycRemark=$req->kycRemark;
		$users->save();
		$req->session()->flash('success','Update successfully');
		return redirect('/admin/viewexpertdetail/'.$req->id);    	
	}

	// Update Expert
	function UpdateExpert($id)
	{
 		$users = users::find($id);
 		$kycdata = userkyc::where('userID','=',$id)->first();
		if(!empty($kycdata->passbookImage)){Session::put('passbook_image', $kycdata->passbookImage);}
		if(!empty($kycdata->kycDocumnetImg)){Session::put('kycdoc_image', $kycdata->kycDocumnetImg);}
		return view('/admin/updateexpert',['data'=>$users,'kycdata'=>$kycdata]);     	
	}

	function Save(Request $req)
	{
		if(request()->passbookPhoto != null)
		{			
			$passbookPhoto = request()->validate(['passbookPhoto' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:1024',]);
			$passbook = time().'.'.request()->passbookPhoto->getClientOriginalExtension();
			request()->passbookPhoto->move(public_path('images/passbook'), $passbook);
			unlink(public_path('images/passbook/'.session()->get('passbook_image')));
		}
		if(!empty($passbook)){ $passbook = $passbook; } else { $passbook = session()->get('passbook_image'); }
		if(request()->kycDocumnetPhoto != null)
		{			
			$kycDocumnetPhoto = request()->validate(['kycDocumnetPhoto' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:1024',]);
			$kycdoc = time().'.'.request()->kycDocumnetPhoto->getClientOriginalExtension();
			request()->kycDocumnetPhoto->move(public_path('images/kycdoc'), $kycdoc);	
			unlink(public_path('images/kycdoc/'.session()->get('kycdoc_image')));
		}
		if(!empty($kycdoc)){ $kycdoc = $kycdoc; } else { $kycdoc = session()->get('kycdoc_image'); }
		
		$users = users::find($req->id);
		$users->kycStatus='Y';
		$users->userName=$req->userName;
		$users->userMobile=$req->userMobile;
		$users->userEmail=$req->userEmail;
		$users->userType='4';
		$users->gender=$req->gender;
		$users->age=$req->age;
		$users->userLocation=$req->userLocation;
 		$users->city=$req->city;
 		$users->district=$req->district;
 		$users->state=$req->state;
 		$users->pincode=$req->pincode;
 		if(!empty($req->userPassword)){$users->userPassword=md5($req->userPassword);}
		$users->save();

		$userkyc = userkyc::where('userID','=',$req->id)
					->update([
							"accountNumber" => $req->accountNumber,
							"accountHolderName" => $req->accountHolderName,
							"bankName" => $req->bankName,
							"ifscCode" => $req->ifscCode,
							"passbookImage" => $passbook,
							"kycDocumentName" => $req->kycDocumentName,
							"kycDocumnetImg" => $kycdoc
							]);
		$req->session()->flash('success','Update successfully');
		return redirect('/admin/experts');
	}


	function GetExpertSchedule(Request $req)
	{
		$schedule = expertschedule::where('expertID','=',$req->expertID)->where('flag','=','1')->where('status','=','1')->get();
		$data ='<option value="">Select</option>';
		foreach($schedule as $item){
				$data .='<option value="'.$item->id.'">'.$item->scheduleDay.'</option>';
		}
		return $data;
	}


	// Delete Expert
	function DeleteExpert(Request $req)
	{
 		$users = users::find($req->id);
 		$users->flag='0';
		$users->save();
		$req->session()->flash('success','Delete successfully');
		return redirect('/admin/experts');     	
	}

}
