<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Contracts\Encryption\DecryptException;
use Facade\Ignition\Exceptions\ViewException;
use Session;
use App\Models\category;
use App\Models\subcategory;
use App\Models\seedgrain;

class GrainSeedController extends Controller
{
	// All Seed Grain
    function AllGrainSeeds()
	{
		$seedgrain = seedgrain::leftJoin('user', function($join) {
			$join->on('user.id', '=', 'seed_grain.userID');
			})
			->leftJoin('category', function($join) {
			$join->on('category.categoryID', '=', 'seed_grain.categoryType');
			})			->leftJoin('subcategory', function($join) {
			$join->on('subcategory.id', '=', 'seed_grain.subCategoryID');
			})
			->get();
		return view('admin.grainseeds',['data'=>$seedgrain]);
	}

	// Delete Grain Seeds
	function DeleteGrainSeeds(Request $req)
	{
		$seedgrain = seedgrain::where('seedID','=',$req->id)->delete();
		return redirect()->back();
	}
}
