<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Contracts\Encryption\DecryptException;
use Facade\Ignition\Exceptions\ViewException;
use Session;
use App\Models\information;

class InformationController extends Controller
{
	// All Information
    function AllInformation()
	{
		$information = information::get();
		return view('admin.informations',['data'=>$information]);
	}

	// Add Information
    function AddInformation()
	{
		return view('admin.addinformation');
	}

    function AddInformationData(Request $req)
	{
		$information = new information;
		$information->infoTitle=$req->infoTitle;
		$information->infoUrl=$req->infoUrl;
		$information->infoDescription=$req->infoDescription;
		$information->infoMobileNo=$req->infoMobileNo;
		$information->infoEmail=$req->infoEmail;
		$information->infoAddress=$req->infoAddress;
		$information->save();
		$req->session()->flash('success','Add successfully');
		return redirect('/admin/information');
	}

	// View Information
	function ViewInformation($id)
	{
 		$information = information::where('id','=',$id)->first();
		return view('/admin/viewinformation',['data'=>$information]);     	
	}

	// Update Information
	function UpdateInformation($id)
	{
 		$information = information::where('id','=',$id)->first();
		return view('admin.updateinformation',['data'=>$information]);     	
	}

	function Save(Request $req)
	{
 		$information = information::where('id','=',$req->id)
					->update([			
							"infoTitle" => $req->infoTitle,
							"infoUrl" => $req->infoUrl,
							"infoDescription" => $req->infoDescription,
							"infoMobileNo" => $req->infoMobileNo,
							"infoEmail" => $req->infoEmail,
							"infoAddress" => $req->infoAddress
							]);
		$req->session()->flash('success','Update successfully');
		return redirect('/admin/information');    	
	}

	// Active Information
	function ActiveInformation(Request $req)
	{
 		$information = information::where('id','=',$req->id)
					->update(["flag" => "1"]);
		$req->session()->flash('success','Active successfully');
		return redirect('/admin/information');     	
	}

	// Deactive Information
	function DeactiveInformation(Request $req)
	{
 		$information = information::where('id','=',$req->id)
					->update(["flag" => "0"]);
		$req->session()->flash('success','Deactive successfully');
		return redirect('/admin/information');     	
	}

	// Delete Information
	function DeleteInformation(Request $req)
	{

 		$information = information::where('id','=',$req->id)->delete();
		$req->session()->flash('success','Delete successfully');
		return redirect('/admin/information');     	
	}

}
