<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Contracts\Encryption\DecryptException;
use Facade\Ignition\Exceptions\ViewException;
use Session;
use App\Models\stories;

class NewsController extends Controller
{
	// All News
    function AllNews()
	{
		$stories = stories::get();
		return view('admin.news',['data'=>$stories]);
	}

	// Add News
    function AddNews()
	{
		return view('admin.addnews');
	}

    function AddNewsData(Request $req)
	{
		if(request()->storyThumbnail != null) {			
			request()->validate(['storyThumbnail' => 'image|mimes:jpeg,png,jpg,gif,svg|max:500',]);
			$storythumbnail = time().'.'.request()->storyThumbnail->getClientOriginalExtension();
			request()->storyThumbnail->move(public_path('images/stories/thumbnail'), $storythumbnail);
		}
		if(request()->image != null) {			
			request()->validate(['image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:500',]);
			$imageName = time().'.'.request()->image->getClientOriginalExtension();
			request()->image->move(public_path('images/stories/image'), $imageName);
		}
		if(request()->video != null) {	
			request()->validate(['video' => 'mimes:mp4,ppx, ppt, pptx,pdf,ogv,jpg,webm|max:102400',]);
			$imageName = time().'.'.request()->video->getClientOriginalExtension();
			request()->video->move(public_path('images/stories/video'), $imageName);			
		}
		$stories = new stories;
		$stories->storyType=$req->storyType;
		$stories->storyTitle=$req->storyTitle;
		$stories->storyDescription=$req->storyDescription;
		$stories->storyThumbnail=$storythumbnail;
		$stories->newsLink=$req->newsLink;
		$stories->url=$imageName;
		$stories->save();
		$req->session()->flash('success','Add successfully');
		return redirect('/admin/news');
	}

	// View News
	function ViewNews($id)
	{
 		$stories = stories::where('storyID','=',$id)->first();
		return view('/admin/viewnews',['data'=>$stories]);     	
	}


	// Update Category
	function UpdateNews($id)
	{
 		$stories = stories::where('storyID','=',$id)->first();
		Session::put('url', $stories->url);
		Session::put('thumbnail', $stories->storyThumbnail);
		return view('admin.updatenews',['data'=>$stories]);     	
	}

	function Save(Request $req)
	{

		if(request()->storyThumbnail != null) {			
			request()->validate(['storyThumbnail' => 'image|mimes:jpeg,png,jpg,gif,svg|max:500',]);
			$storythumbnail = time().'.'.request()->storyThumbnail->getClientOriginalExtension();
			request()->storyThumbnail->move(public_path('images/stories/thumbnail'), $storythumbnail);
			unlink(public_path('images/stories/thumbnail/'.session()->get('thumbnail')));
		}
		if(request()->image != null) {			
			request()->validate(['image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:500',]);
			$imageName = time().'.'.request()->image->getClientOriginalExtension();
			request()->image->move(public_path('images/stories/image'), $imageName);
			unlink(public_path('images/stories/image/'.session()->get('url')));
		}
		if(request()->video != null) {	
			request()->validate(['video' => 'mimes:mp4,ppx, ppt, pptx,pdf,ogv,jpg,webm|max:102400',]);
			$imageName = time().'.'.request()->video->getClientOriginalExtension();
			request()->video->move(public_path('images/stories/video'), $imageName);
			unlink(public_path('images/stories/video/'.session()->get('url')));
		}
		if(!empty($storythumbnail)){ $thumbnail = $storythumbnail; } else { $thumbnail = session()->get('thumbnail'); }
		if(!empty($imageName)){ $image = $imageName; } else { $image = session()->get('url'); }

 		$stories = stories::where('storyID','=',$req->id)
					->update([			
							"storyType" => $req->storyType,
							"storyTitle" => $req->storyTitle,
							"storyDescription" => $req->storyDescription,
							"storyThumbnail" => $thumbnail,
							"newsLink" => $req->newsLink,
							"url" => $image
							]);
		$req->session()->flash('success','Update successfully');
		return redirect('/admin/news');    	
	}

	// Active News
	function ActiveNews(Request $req)
	{
 		$stories = stories::where('storyID','=',$req->id)
					->update(["flag" => "1"]);
		$req->session()->flash('success','Active successfully');
		return redirect('/admin/news');     	
	}

	// Deactive News
	function DeactiveNews(Request $req)
	{
 		$stories = stories::where('storyID','=',$req->id)
					->update(["flag" => "0"]);
		$req->session()->flash('success','Deactive successfully');
		return redirect('/admin/news');     	
	}

	// Delete Category
	function DeleteNews(Request $req)
	{

 		$stories = stories::where('storyID','=',$req->id)->first();
		Session::put('url', $stories->url);
		Session::put('storyType', $stories->storyType);
 		$stories = stories::where('storyID','=',$req->id)->delete();
		if(session()->get('storyType') == 'Image'){
		unlink(public_path('images/stories/image/'.session()->get('url')));}
		else{
		unlink(public_path('images/stories/video/'.session()->get('url')));}
		$req->session()->flash('success','Delete successfully');
		return redirect('/admin/news');     	
	}

}
