<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Contracts\Encryption\DecryptException;
use Facade\Ignition\Exceptions\ViewException;
use Session;
use App\Models\transactionhistory;

class RequestForCashController extends Controller
{
	// All Request For Cash Kishan
    function RequestForCashKishan()
	{
		$data = transactionhistory::leftJoin('user', function($join) {
			$join->on('transactionhistory.userID', '=', 'user.id');
			})
			->where('transactionhistory.userTransactionType','=','P')
			->orwhere('transactionhistory.userTransactionType','=','D')
			->where('transactionhistory.paymentFor','=','R')
			->orderBy('transactionhistory.id','DESC')
			->get([
			'transactionhistory.id',
			'user.userName',
			'user.userMobile',
			'transactionhistory.amount',
			'transactionhistory.transactionStatus',
			'transactionhistory.remark',
			'transactionhistory.created_at',
			]);
		return view('admin.requestforcashkishan',['data'=>$data]);
	}

	// Approve Cash Request Kishan
	function ApproveCashRequestKishan(Request $req)
	{
		$transactionhistory = transactionhistory::find($req->id);
		$transactionhistory->userTransactionType='D';
		$transactionhistory->transactionStatus='Success';
		$transactionhistory->save();
		return redirect()->back();
	}

	// Reject Cash Request Kishan
	function RejectCashRequestKishan(Request $req)
	{
		$transactionhistory = transactionhistory::find($req->id);
		$transactionhistory->userTransactionType='R';
		$transactionhistory->transactionStatus='Reject';
		$transactionhistory->save();
		return redirect()->back();
	}

	// All Request For Cash Vender
    function RequestForCashVender()
	{
		$data = transactionhistory::leftJoin('user', function($join) {
			$join->on('transactionhistory.venderID', '=', 'user.id');
			})
			->where('transactionhistory.venderTransactionType','=','P')
			->orwhere('transactionhistory.venderTransactionType','=','D')
			->where('transactionhistory.paymentFor','=','R')
			->orderBy('transactionhistory.id','DESC')
			->get([
			'transactionhistory.id',
			'user.shopName',
			'user.userMobile',
			'transactionhistory.amount',
			'transactionhistory.transactionStatus',
			'transactionhistory.remark',
			'transactionhistory.created_at',
			]);
		return view('admin.requestforcashvender',['data'=>$data]);
	}

	// Approve Cash Request Kishan
	function ApproveCashRequestVender(Request $req)
	{
		$transactionhistory = transactionhistory::find($req->id);
		$transactionhistory->venderTransactionType='D';
		$transactionhistory->transactionStatus='Success';
		$transactionhistory->save();
		return redirect()->back();
	}

	// Reject Cash Request Kishan
	function RejectCashRequestVender(Request $req)
	{
		$transactionhistory = transactionhistory::find($req->id);
		$transactionhistory->transactionStatus='Reject';
		$transactionhistory->save();
		return redirect()->back();
	}

}
