<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Contracts\Encryption\DecryptException;
use Facade\Ignition\Exceptions\ViewException;
use Session;
use App\Models\users;
use App\Models\services;
use App\Models\coustomerenquiry;

class RequestForGrainSeedsController extends Controller
{
	// All Request For Grain/Seeds
    function RequestForGrainSeeds()
	{
		$coustomerenquiry = coustomerenquiry::leftJoin('user', function($join) {
			$join->on('coustomer_enquiry.userID', '=', 'user.id');
			})
			->leftJoin('seed_grain', function($join) {
			$join->on('coustomer_enquiry.seedID', '=', 'seed_grain.seedID');
			})			
			->where('coustomer_enquiry.flag','=','1')
			->orderBy('coustomer_enquiry.id','DESC')
			->get([
			'coustomer_enquiry.id',
			'user.userName',
			'user.userMobile',
			'seed_grain.seedsName',
			'coustomer_enquiry.quantity',
			'coustomer_enquiry.description',
			'coustomer_enquiry.request_for',
			'coustomer_enquiry.status',
			'coustomer_enquiry.created_at'
			]);
		return view('admin.requestforgrainseeds',['data'=>$coustomerenquiry]);
	}

	// Approve Request 
	function ApproveRequest(Request $req)
	{
		$coustomerenquiry = coustomerenquiry::find($req->id);
		$coustomerenquiry->status='Approve';
		$coustomerenquiry->save();
		return redirect()->back();
	}

	// Reject Request 
	function RejectRequest(Request $req)
	{
		$coustomerenquiry = coustomerenquiry::find($req->id);
		$coustomerenquiry->status='Reject';
		$coustomerenquiry->save();
		return redirect()->back();
	}

}
