<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Contracts\Encryption\DecryptException;
use Facade\Ignition\Exceptions\ViewException;
use Session;
use App\Models\users;
use App\Models\services;
use App\Models\servicerequest;
use App\Models\assignexpert;

class ServiceRequestController extends Controller
{
	// All Service Request
    function AllServiceRequest()
	{
		$servicerequest = servicerequest::leftJoin('user', function($join) {
			$join->on('servicerequest.userID', '=', 'user.id');
			})
			->leftJoin('services', function($join) {
			$join->on('servicerequest.serviceID', '=', 'services.id');
			})			
			->where('servicerequest.flag','=','1')
			->orderBy('servicerequest.id','DESC')
			->get([
			'servicerequest.id',
			'user.userName',
			'user.userMobile',
			'services.serviceType',
			'services.serviceTitle',
			'servicerequest.expertID',
			'servicerequest.serviceDate',
			'servicerequest.serviceTime',
			'servicerequest.serviceMessage',
			'servicerequest.serviceStatus',
			]);
		return view('admin.servicerequest',['data'=>$servicerequest]);
	}

	// Today Service Request
    function TodayServiceRequest()
	{
		$servicerequest = servicerequest::leftJoin('user', function($join) {
			$join->on('servicerequest.userID', '=', 'user.id');
			})
			->leftJoin('services', function($join) {
			$join->on('servicerequest.serviceID', '=', 'services.id');
			})			
			->where('servicerequest.serviceDate','=',date('Y-m-d'))
			->where('servicerequest.flag','=','1')
			->get([
			'servicerequest.id',
			'user.userName',
			'user.userMobile',
			'services.serviceType',
			'services.serviceTitle',
			'servicerequest.expertID',
			'servicerequest.serviceDate',
			'servicerequest.serviceTime',
			'servicerequest.serviceMessage',
			'servicerequest.serviceStatus',
			]);
		return view('admin.todayservicerequest',['data'=>$servicerequest]);
	}

	// Assigned Service Request
    function AssignedServiceRequest()
	{
		$servicerequest = servicerequest::leftJoin('user', function($join) {
			$join->on('servicerequest.userID', '=', 'user.id');
			})
			->leftJoin('services', function($join) {
			$join->on('servicerequest.serviceID', '=', 'services.id');
			})			
			->where('servicerequest.expertID','!=','0')
			->where('servicerequest.flag','=','1')
			->get([
			'servicerequest.id',
			'user.userName',
			'user.userMobile',
			'services.serviceType',
			'services.serviceTitle',
			'servicerequest.expertID',
			'servicerequest.serviceDate',
			'servicerequest.serviceTime',
			'servicerequest.serviceMessage',
			'servicerequest.serviceStatus',
			]);
		return view('admin.assignedservicerequest',['data'=>$servicerequest]);
	}

	// Unassigned Service Request
    function UnassignedServiceRequest()
	{
		$servicerequest = servicerequest::leftJoin('user', function($join) {
			$join->on('servicerequest.userID', '=', 'user.id');
			})
			->leftJoin('services', function($join) {
			$join->on('servicerequest.serviceID', '=', 'services.id');
			})			
			->where('servicerequest.expertID','=','0')
			->where('servicerequest.flag','=','1')
			->get([
			'servicerequest.id',
			'user.userName',
			'user.userMobile',
			'services.serviceType',
			'services.serviceTitle',
			'servicerequest.expertID',
			'servicerequest.serviceDate',
			'servicerequest.serviceTime',
			'servicerequest.serviceMessage',
			'servicerequest.serviceStatus',
			]);
		return view('admin.unassignedservicerequest',['data'=>$servicerequest]);
	}

	// Add Service Expert
    function AssignExpert($id)
	{
		$experts = users::where('userType','=','4')->where('flag','=','1')->get();
		$servicerequest = servicerequest::find($id);
		return view('admin.assignexpert',['data'=>$servicerequest,'expert'=>$experts]);
	}

    function AssignExpertData(Request $req)
	{
		$assignexpert = new assignexpert;
		$assignexpert->userID=$req->userID;
		$assignexpert->serviceID=$req->serviceID;
		$assignexpert->serviceRequestID=$req->serviceRequestID;
		$assignexpert->expertID=$req->expertID;
		$assignexpert->assignDate=$req->assignDate;
		$assignexpert->assignTime=$req->assignTime;
		$assignexpert->assignRemark=$req->assignRemark;
		$assignexpert->save();

 		$servicerequest = servicerequest::where('id','=',$req->serviceRequestID)
						  ->update([			
							"expertID" => $req->expertID
							]);

		$expert = users::where('id','=',$req->expertID)->first();

		$url = 'https://fcm.googleapis.com/fcm/send';
		$expertFirebaseToken = $expert->firebaseToken;
		$fields = array(
			'to' => $expertFirebaseToken,
			'data' => $message = array(
					"title" => "You are assigned for service request",
					"description" => "Your Schedule Date: ".date('d/m/Y',strtotime($req->assignDate))." & Time: ".date('h:i A',strtotime($req->assignTime)),
					"type" => "service",
					"userID" => $req->userID,
					"serviceID" => $req->serviceID,
					"serviceRequestID" => $req->serviceRequestID,
					"expertID" => $req->expertID,
					"assignDate" => $req->assignDate,
					"assignTime" => $req->assignTime,
					"assignRemark" => $req->assignRemark
				)
			);
		$headers = array(
			'Authorization: key=AAAA2mDHqe8:APA91bGWLbNJ8kA3ezBECkTgP4Wx_wH9LFHF-_4ayhKk0gftd_0XQN68dytJbqhmTh_BDGBw9Ps_EjUDzer9hp6Yhspq1yrc_nhf7fU8TWUtlPrN6prZDxkfsD3tb6aODlrF_7eu1kgT',
			'Content-type: Application/json'
			);

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
		curl_exec($ch);
		curl_close($ch);

		$req->session()->flash('success','Expert assign successfully');
		return redirect('/admin/servicerequest');
	}

	// Delete Services
	function DeleteServiceRequest(Request $req)
	{
 		$servicerequest = servicerequest::where('id','=',$req->id)->delete();
		$req->session()->flash('success','Delete successfully');
		return redirect('/admin/servicerequest');     	
	}

}
