<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Contracts\Encryption\DecryptException;
use Facade\Ignition\Exceptions\ViewException;
use Session;
use App\Models\services;

class ServicesController extends Controller
{
	// All Services
    function AllServices()
	{
		$services = services::get();
		return view('admin.services',['data'=>$services]);
	}

	// Add Services
    function AddService()
	{
		return view('admin.addservice');
	}

    function AddServiceData(Request $req)
	{
		$services = new services;
		$services->serviceType=$req->serviceType;
		$services->serviceTitle=$req->serviceTitle;
		$services->servicePrice=$req->servicePrice;
		$services->serviceValidity=$req->serviceValidity;
		$services->serviceDescription=$req->serviceDescription;
		$services->save();
		$req->session()->flash('success','Add successfully');
		return redirect('/admin/services');
	}

	// View Services
	function ViewService($id)
	{
 		$services = services::where('id','=',$id)->first();
		return view('/admin/viewservice',['data'=>$services]);     	
	}

	// Update Services
	function UpdateService($id)
	{
 		$services = services::where('id','=',$id)->first();
		return view('admin.updateservice',['data'=>$services]);     	
	}

	function Save(Request $req)
	{
 		$services = services::where('id','=',$req->id)
					->update([			
							"serviceType" => $req->serviceType,
							"serviceTitle" => $req->serviceTitle,
							"servicePrice" => $req->servicePrice,
							"serviceValidity" => $req->serviceValidity,
							"serviceDescription" => $req->serviceDescription
							]);
		$req->session()->flash('success','Update successfully');
		return redirect('/admin/services');    	
	}

	// Active Services
	function ActiveService(Request $req)
	{
 		$services = services::where('id','=',$req->id)
					->update(["flag" => "1"]);
		$req->session()->flash('success','Active successfully');
		return redirect('/admin/services');     	
	}

	// Deactive Services
	function DeactiveService(Request $req)
	{
 		$services = services::where('id','=',$req->id)
					->update(["flag" => "0"]);
		$req->session()->flash('success','Deactive successfully');
		return redirect('/admin/services');     	
	}

	// Delete Services
	function DeleteService(Request $req)
	{

 		$services = services::where('id','=',$req->id)->delete();
		$req->session()->flash('success','Delete successfully');
		return redirect('/admin/services');     	
	}

}
