<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Contracts\Encryption\DecryptException;
use Facade\Ignition\Exceptions\ViewException;
use Session;
use App\Models\shoptype;

class ShopTypeController extends Controller
{
	// All ShopType
    function AllShopType()
	{
		$shoptype = shoptype::get();
		return view('admin.shoptype',['data'=>$shoptype]);
	}

	// Add ShopType
    function AddShopType()
	{
		return view('admin.addshoptype');
	}

    function AddShopTypeData(Request $req)
	{
		$count = shoptype::where('shopType','=',$req->shopType)->where('flag','=','1')->count();
		if($count > 0){ $req->session()->flash('error','Already exists'); return redirect()->back()->withInput();}

		$shoptype = new shoptype;
		$shoptype->shopType=$req->shopType;
		$shoptype->save();
		$req->session()->flash('success','Add successfully');
		return redirect('/admin/shoptype');
	}

	// Update ShopType
	function UpdateShopType($id)
	{
 		$shoptype = shoptype::where('id','=',$id)->first();
		return view('admin.updateshoptype',['data'=>$shoptype]);     	
	}

	function Save(Request $req)
	{
 		$shoptype = shoptype::find($req->id);
		$shoptype->shopType=$req->shopType;
		$shoptype->save();
		$req->session()->flash('success','Update successfully');
		return redirect('/admin/shoptype');    	
	}

	// Delete ShopType
	function DeleteShopType(Request $req)
	{

 		$shoptype = shoptype::where('id','=',$req->id)->delete();
		$req->session()->flash('success','Delete successfully');
		return redirect('/admin/shoptype');     	
	}

}
