<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Contracts\Encryption\DecryptException;
use Facade\Ignition\Exceptions\ViewException;
use Session;
use App\Models\category;
use App\Models\subcategory;

class SubCategoryController extends Controller
{
	// All Sub Category
    function AllSubCategory()
	{
		$subcategory = subcategory::leftJoin('category', function($join) {
			$join->on('subcategory.categoryID', '=', 'category.categoryID');
			})
			->where('category.flag','=','1')
			->get([
			'subcategory.id',
			'category.categoryName',
			'subcategory.subCategoryName',
			'subcategory.subCategoryDescription',
			'subcategory.subCategoryImage',
			'subcategory.orderBy',
			'subcategory.flag',
			]);
		return view('admin.subcategory',['data'=>$subcategory]);
	}

	// Add Category
    function AddSubCategory()
	{
		$category = category::where('flag','=','1')->get();
		return view('admin.addsubcategory',['category'=>$category]);
	}

    function AddSubCategoryData(Request $req)
	{

		request()->validate(['image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:500',]);

		$imageName = time().'.'.request()->image->getClientOriginalExtension();
		request()->image->move(public_path('images/subcategory'), $imageName);			

		$subcategory = new subcategory;
		$subcategory->categoryID=$req->categoryID;
		$subcategory->subCategoryName=$req->subCategoryName;
		$subcategory->subCategoryImage=$imageName;
 		$subcategory->subCategoryDescription=$req->subCategoryDescription;
 		$subcategory->orderBy=$req->orderBy;
		$subcategory->save();
		$req->session()->flash('success','Add successfully');
		return redirect('/admin/subcategory');
	}

	// Update Category
	function UpdateSubCategory($id)
	{
		$category = category::where('flag','=','1')->get();
		$subcategory = subcategory::where('id','=',$id)->first();
		Session::put('category_image', $subcategory->subCategoryImage);
		return view('admin.updatesubcategory',['category'=>$category,'data'=>$subcategory]);     	
	}

	function Save(Request $req)
	{

		if(request()->image != null)
		{			
			request()->validate([
			'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:500',
			]);

			$imageName = time().'.'.request()->image->getClientOriginalExtension();
			request()->image->move(public_path('images/subcategory'), $imageName);	
			unlink(public_path('images/subcategory/'.session()->get('category_image')));
		}
		
		if(!empty($imageName)){ $image = $imageName; } else { $image = session()->get('category_image'); }

 		$subcategory = subcategory::where('id','=',$req->id)
					->update([			
							"categoryID" => $req->categoryID,
							"subCategoryName" => $req->subCategoryName,
							"subCategoryImage" => $image,
							"subCategoryDescription" => $req->subCategoryDescription,
							"orderBy" => $req->orderBy
							]);
		$req->session()->flash('success','Update successfully');
		return redirect('/admin/subcategory');    	
	}

	// Active Category
	function ActiveSubCategory(Request $req)
	{
 		$subcategory = subcategory::where('id','=',$req->id)
					->update(["flag" => "1"]);
		$req->session()->flash('success','Active successfully');
		return redirect('/admin/subcategory');     	
	}

	// Deactive Category
	function DeactiveSubCategory(Request $req)
	{
 		$subcategory = subcategory::where('id','=',$req->id)
					->update(["flag" => "0"]);
		$req->session()->flash('success','Deactive successfully');
		return redirect('/admin/subcategory');     	
	}

	// Delete Category
	function DeleteSubCategory(Request $req)
	{
 		$subcategory = subcategory::where('id','=',$req->id)->first();
		Session::put('category_image', $subcategory->subCategoryImage);
 		$subcategory = subcategory::where('id','=',$req->id)->delete();
		unlink(public_path('images/subcategory/'.session()->get('category_image')));
		$req->session()->flash('success','Delete successfully');
		return redirect('/admin/subcategory');     	
	}

}
