<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Contracts\Encryption\DecryptException;
use Facade\Ignition\Exceptions\ViewException;
use Session;
use Crypt;

use App\Models\users;
use App\Models\userkyc;
use App\Models\transactionhistory;

class UserController extends Controller
{
	// Kishan
    function Kishan()
	{
		$user = users::where('flag','=','1')->where('userType','=','1')->get();
		return view('admin.kishan',['data'=>$user]);
	}

	// Add Kishan
    function addKishan()
	{
		return view('admin.addkishan');
	}

    function AddKishanData(Request $req)
	{

		$passbookPhoto = request()->validate(['passbookPhoto' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:1024',]);
		$kycDocumnetPhoto = request()->validate(['kycDocumnetPhoto' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:1024',]);

		$passbook = time().'.'.request()->passbookPhoto->getClientOriginalExtension();
		request()->passbookPhoto->move(public_path('images/passbook'), $passbook);		

		$kycdoc = time().'.'.request()->kycDocumnetPhoto->getClientOriginalExtension();
		request()->kycDocumnetPhoto->move(public_path('images/kycdoc'), $kycdoc);		

		$users = new users;
		$users->kycStatus='Y';
		$users->kycVerifiedStatus='Verified';
		$users->userName=$req->userName;
		$users->userMobile=$req->userMobile;
		$users->userEmail=$req->userEmail;
		$users->userType='1';
		$users->gender=$req->gender;
		$users->age=$req->age;
		$users->userLocation=$req->userLocation;
 		$users->city=$req->city;
 		$users->district=$req->district;
 		$users->state=$req->state;
 		$users->pincode=$req->pincode;
 		$users->userPassword=md5($req->userPassword);
		$users->save();

		$userkyc = new userkyc;
		$userkyc->userID=$users->id;
		$userkyc->accountNumber=$req->accountNumber;
		$userkyc->accountHolderName=$req->accountHolderName;
		$userkyc->bankName=$req->bankName;
		$userkyc->ifscCode=$req->ifscCode;
		$userkyc->passbookImage=$passbook;
		$userkyc->kycDocumentName=$req->kycDocumentName;
		$userkyc->kycDocumnetImg=$kycdoc;
		$userkyc->save();
		$req->session()->flash('success','Add successfully');
		return redirect('/admin/kishan');
	}

	// View Kishan
	function ViewKishanDetail($id)
	{
 		$users = users::find($id);
 		$kycdata = userkyc::where('userID','=',$id)->first();
		return view('/admin/viewkishandetail',['data'=>$users,'kycdata'=>$kycdata]);     	
	}

	// Update Kishan KYC Status
	function UpdateKYCStatus(Request $req)
	{
 		$users = users::find($req->id);
		$users->kycVerifiedStatus=$req->kycVerifiedStatus;
		$users->kycRemark=$req->kycRemark;
		$users->save();
		$req->session()->flash('success','Update successfully');
		return redirect('/admin/viewkishandetail/'.$req->id);    	
	}

	// Update Kishan
	function UpdateKishan($id)
	{
 		$users = users::find($id);
 		$kycdata = userkyc::where('userID','=',$id)->first();
		if(!empty($kycdata->passbookImage)){Session::put('passbook_image', $kycdata->passbookImage);}
		if(!empty($kycdata->kycDocumnetImg)){Session::put('kycdoc_image', $kycdata->kycDocumnetImg);}
		return view('/admin/updatekishan',['data'=>$users,'kycdata'=>$kycdata]);     	
	}

	function Save(Request $req)
	{
		if(request()->passbookPhoto != null)
		{			
			$passbookPhoto = request()->validate(['passbookPhoto' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:1024',]);
			$passbook = time().'.'.request()->passbookPhoto->getClientOriginalExtension();
			request()->passbookPhoto->move(public_path('images/passbook'), $passbook);
			unlink(public_path('images/passbook/'.session()->get('passbook_image')));
		}
		if(!empty($passbook)){ $passbook = $passbook; } else { $passbook = session()->get('passbook_image'); }
		if(request()->kycDocumnetPhoto != null)
		{			
			$kycDocumnetPhoto = request()->validate(['kycDocumnetPhoto' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:1024',]);
			$kycdoc = time().'.'.request()->kycDocumnetPhoto->getClientOriginalExtension();
			request()->kycDocumnetPhoto->move(public_path('images/kycdoc'), $kycdoc);	
			unlink(public_path('images/kycdoc/'.session()->get('kycdoc_image')));
		}
		if(!empty($kycdoc)){ $kycdoc = $kycdoc; } else { $kycdoc = session()->get('kycdoc_image'); }
		
		$users = users::find($req->id);
		$users->kycStatus='Y';
		$users->userName=$req->userName;
		$users->userMobile=$req->userMobile;
		$users->userEmail=$req->userEmail;
		$users->userType='1';
		$users->gender=$req->gender;
		$users->age=$req->age;
		$users->userLocation=$req->userLocation;
 		$users->city=$req->city;
 		$users->district=$req->district;
 		$users->state=$req->state;
 		$users->pincode=$req->pincode;
 		$users->userPassword=md5($req->userPassword);
		$users->save();

		$userkyc = userkyc::where('userID','=',$req->id)
					->update([
							"accountNumber" => $req->accountNumber,
							"accountHolderName" => $req->accountHolderName,
							"bankName" => $req->bankName,
							"ifscCode" => $req->ifscCode,
							"passbookImage" => $passbook,
							"kycDocumentName" => $req->kycDocumentName,
							"kycDocumnetImg" => $kycdoc
							]);
		$req->session()->flash('success','Update successfully');
		return redirect('/admin/kishan');
	}

	// View Kishan Transaction History
	function ViewKishanTransactionHistory($id)
	{
 		$user = users::find($id);
 		$transactionhistory = transactionhistory::leftJoin('user', function($join) {
			$join->on('transactionhistory.venderID', '=', 'user.id');
			})			
			->where('transactionhistory.userID','=',$id)
			->orderBY('transactionhistory.id','ASC')
			->orderBY('transactionhistory.created_at','ASC')
			->get([
			'transactionhistory.id',
			'transactionhistory.userTransactionType',
			'transactionhistory.amount',
			'transactionhistory.transactionID',
			'transactionhistory.transactionStatus',
			'transactionhistory.paymentFor',
			'transactionhistory.created_at',
			'user.shopName'
			]);
		return view('/admin/kishantransactionhistory',['user'=>$user,'transactionhistory'=>$transactionhistory]);     	
	}

	// Add Kishan Credit
    function KishanCredit($id)
	{
		$data = $id;
		return view('admin.addkishancredit',['data'=>$data]);   
	}

    function AddKishanCredit(Request $req)
	{

		$duedate = date('Y-m-d', strtotime(date('d-m-Y').' + '.$req->days.' days'));


		$users = users::find($req->kishanID);
		$users->duedate=$duedate;
		$users->save();


		$transactionhistory = new transactionhistory;
		$transactionhistory->userID=$req->kishanID;
		$transactionhistory->venderID='0';
		$transactionhistory->userTransactionType='C';
		$transactionhistory->amount=$req->amount;
		$transactionhistory->transactionStatus='Success';
		$transactionhistory->paymentFor='A';
		$transactionhistory->duedate=$duedate;
		$transactionhistory->save();
		$req->session()->flash('success','Credit add successfully');
		return redirect('/admin/kishantransactionhistory/'.$req->kishanID);
	}


	// Delete Kishan
	function DeleteKishan(Request $req)
	{
 		$users = users::find($req->id);
 		$users->flag='0';
		$users->save();
		$req->session()->flash('success','Delete successfully');
		return redirect('/admin/kishan');     	
	}

}
