<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Contracts\Encryption\DecryptException;
use Facade\Ignition\Exceptions\ViewException;
use Session;
use Crypt;

use App\Models\users;
use App\Models\userkyc;
use App\Models\shoptype;
use App\Models\transactionhistory;

class VenderController extends Controller
{

	// Vender
    function Vender()
	{
		$user = users::where('flag','=','1')->where('userType','=','2')->get();
		return view('admin.vender',['data'=>$user]);
	}

	// Add Vender
    function addVender()
	{
		$shoptype = shoptype::where('flag','=','1')->get();
		return view('admin.addvender',['data'=>$shoptype]);
	}

    function AddVenderData(Request $req)
	{

		$passbookPhoto = request()->validate(['passbookPhoto' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:1024',]);
		$kycDocumnetPhoto = request()->validate(['kycDocumnetPhoto' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:1024',]);

		$passbook = time().'.'.request()->passbookPhoto->getClientOriginalExtension();
		request()->passbookPhoto->move(public_path('images/passbook'), $passbook);		

		$kycdoc = time().'.'.request()->kycDocumnetPhoto->getClientOriginalExtension();
		request()->kycDocumnetPhoto->move(public_path('images/kycdoc'), $kycdoc);		

		$users = new users;
		$users->kycStatus='Y';
		$users->kycVerifiedStatus='Verified';
		$users->userName=$req->userName;
		$users->userMobile=$req->userMobile;
		$users->userEmail=$req->userEmail;
		$users->userType='2';
		$users->gender=$req->gender;
		$users->age=$req->age;
		$users->shopName=$req->shopName;
		$users->shopType=$req->shopType;
		$users->shopAddress=$req->shopAddress;
		$users->userLocation=$req->userLocation;
 		$users->city=$req->city;
 		$users->district=$req->district;
 		$users->state=$req->state;
 		$users->pincode=$req->pincode;
 		$users->userPassword=$req->userPassword;
		$users->save();

		$userkyc = new userkyc;
		$userkyc->userID=$users->id;
		$userkyc->accountNumber=$req->accountNumber;
		$userkyc->accountHolderName=$req->accountHolderName;
		$userkyc->bankName=$req->bankName;
		$userkyc->ifscCode=$req->ifscCode;
		$userkyc->passbookImage=$passbook;
		$userkyc->kycDocumentName=$req->kycDocumentName;
		$userkyc->kycDocumnetImg=$kycdoc;
		$userkyc->gstRegistrationName=$req->gstRegistrationName;
		$userkyc->gstNumber=$req->gstNumber;
		$userkyc->save();
		$req->session()->flash('success','Add successfully');
		return redirect('/admin/vender');
	}

	// View Vender
	function ViewVenderDetail($id)
	{
 		$users = users::find($id);
 		$kycdata = userkyc::where('userID','=',$id)->first();
		return view('/admin/viewvenderdetail',['data'=>$users,'kycdata'=>$kycdata]);     	
	}

	// Update Vender KYC Status
	function UpdateKYCStatus(Request $req)
	{
 		$users = users::find($req->id);
		$users->kycVerifiedStatus=$req->kycVerifiedStatus;
		$users->kycRemark=$req->kycRemark;
		$users->save();
		$req->session()->flash('success','Update successfully');
		return redirect('/admin/viewvenderdetail/'.$req->id);    	
	}

	// Update Vender
	function UpdateVender($id)
	{
 		$users = users::find($id);
		$shoptype = shoptype::where('flag','=','1')->get();
 		$kycdata = userkyc::where('userID','=',$id)->first();
		if(!empty($kycdata->passbookImage)){Session::put('passbook_image', $kycdata->passbookImage);}
		if(!empty($kycdata->kycDocumnetImg)){Session::put('kycdoc_image', $kycdata->kycDocumnetImg);}
		return view('/admin/updatevender',['data'=>$users,'kycdata'=>$kycdata,'shoptype'=>$shoptype]);     	
	}

	function Save(Request $req)
	{
		if(request()->passbookPhoto != null)
		{			
			$passbookPhoto = request()->validate(['passbookPhoto' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:1024',]);
			$passbook = time().'.'.request()->passbookPhoto->getClientOriginalExtension();
			request()->passbookPhoto->move(public_path('images/passbook'), $passbook);
			unlink(public_path('images/passbook/'.session()->get('passbook_image')));
		}
		if(!empty($passbook)){ $passbook = $passbook; } else { $passbook = session()->get('passbook_image'); }
		if(request()->kycDocumnetPhoto != null)
		{			
			$kycDocumnetPhoto = request()->validate(['kycDocumnetPhoto' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:1024',]);
			$kycdoc = time().'.'.request()->kycDocumnetPhoto->getClientOriginalExtension();
			request()->kycDocumnetPhoto->move(public_path('images/kycdoc'), $kycdoc);	
			unlink(public_path('images/kycdoc/'.session()->get('kycdoc_image')));
		}
		if(!empty($kycdoc)){ $kycdoc = $kycdoc; } else { $kycdoc = session()->get('kycdoc_image'); }
		
		$users = users::find($req->id);
		$users->kycStatus='Y';
		$users->userName=$req->userName;
		$users->userMobile=$req->userMobile;
		$users->userEmail=$req->userEmail;
		$users->userType='2';
		$users->gender=$req->gender;
		$users->age=$req->age;
		$users->shopName=$req->shopName;
		$users->shopType=$req->shopType;
		$users->shopAddress=$req->shopAddress;
		$users->userLocation=$req->userLocation;
 		$users->city=$req->city;
 		$users->district=$req->district;
 		$users->state=$req->state;
 		$users->pincode=$req->pincode;
 		$users->userPassword=$req->userPassword;
		$users->save();

		$userkyc = userkyc::where('userID','=',$req->id)
					->update([
							"accountNumber" => $req->accountNumber,
							"accountHolderName" => $req->accountHolderName,
							"bankName" => $req->bankName,
							"ifscCode" => $req->ifscCode,
							"passbookImage" => $passbook,
							"kycDocumentName" => $req->kycDocumentName,
							"kycDocumnetImg" => $kycdoc,
							"gstRegistrationName" => $req->gstRegistrationName,
							"gstNumber" => $req->gstNumber
							]);
		$req->session()->flash('success','Update successfully');
		return redirect('/admin/vender');
	}

	// View Vender Transaction History
	function ViewVenderTransactionHistory($id)
	{
 		$user = users::find($id);
 		$transactionhistory = transactionhistory::leftJoin('user', function($join) {
			$join->on('transactionhistory.userID', '=', 'user.id');
			})			
			->where('transactionhistory.venderID','=',$id)
			->orderBY('transactionhistory.id','ASC')
			->orderBY('transactionhistory.created_at','ASC')
			->get([
			'transactionhistory.id',
			'transactionhistory.venderTransactionType',
			'transactionhistory.amount',
			'transactionhistory.transactionID',
			'transactionhistory.transactionStatus',
			'transactionhistory.paymentFor',
			'transactionhistory.created_at',
			'user.userName'
			]);
		return view('/admin/vendertransactionhistory',['user'=>$user,'transactionhistory'=>$transactionhistory]);     	
	}

	// Add Vender Credit
    function VenderCredit($id)
	{
		$data = $id;
		return view('admin.addvendercredit',['data'=>$data]);   
	}

    function AddVenderCredit(Request $req)
	{
		$transactionhistory = new transactionhistory;
		$transactionhistory->venderID=$req->venderID;
		$transactionhistory->userID='0';
		$transactionhistory->venderTransactionType='C';
		$transactionhistory->amount=$req->amount;
		$transactionhistory->transactionStatus='Success';
		$transactionhistory->paymentFor='A';
		$transactionhistory->save();
		$req->session()->flash('success','Credit add successfully');
		return redirect('/admin/vendertransactionhistory/'.$req->venderID);
	}

	
	// Delete Vender
	function DeleteVender(Request $req)
	{
 		$users = users::find($req->id);
 		$users->flag='0';
		$users->save();
		$req->session()->flash('success','Delete successfully');
		return redirect('/admin/vender');     	
	}

}
