@extends('admin.layouts.app')

@section('content')
    <section id="main-wrapper" class="theme-dark-full">
        <header id="header">
            <!--logo start-->
            <div class="brand">
                <a href="{{ url('/admin/dashboard') }}" class="logo">
                    <span>{{ Session::get('name') }}</span>
				</a>
            </div>
            <!--logo end-->
            <ul class="nav navbar-nav navbar-left">
                <li class="toggle-navigation toggle-left">
                    <button class="sidebar-toggle" id="toggle-left">
                        <i class="fa fa-bars"></i>
                    </button>
                </li>
            </ul>
            <ul class="nav navbar-nav navbar-right">
                <li class="dropdown profile hidden-xs">
                    <a href="javascript:void(0);" class="dropdown-toggle" data-toggle="dropdown">
                        <span class="meta">
                            <span class="avatar">
                                <img src="{{ URL::to('/') }}/images/{{ Session::get('photo') }}" class="img-circle" alt="">
                            </span>
                        <span class="text">{{ Session::get('name') }}</span>
                        <span class="caret"></span>
                        </span>
                    </a>
                    <ul class="dropdown-menu animated fadeInRight" role="menu">
                        <li>
                            <a href="{{url('/admin/profile')}}/{{ Session::get('id') }}">
                                <span class="icon"><i class="fa fa-user"></i>
                                </span>Profile</a>
                        </li>
                        <li>
                            <a href="{{url('admin/changepassword')}}/{{ Session::get('id') }}">
                                <span class="icon"><i class="fa fa-lock"></i>
                                </span>Change Password</a>
                        </li>
                        <li class="divider"></li>
                        <li>
                            <a href="{{url('/admin/logout')}}">
                                <span class="icon"><i class="fa fa-sign-out"></i>
                                </span>Logout</a>
                        </li>                    </ul>
                </li>
                <li class="toggle-fullscreen hidden-xs">
                    <button type="button" class="btn btn-default expand" id="toggle-fullscreen">
                        <i class="fa fa-expand"></i>
                    </button>
                </li>
            </ul>
        </header>
        <!--sidebar left start-->
        <aside class="sidebar sidebar-left">
            <div class="sidebar-profile">
                <div class="avatar">
                    <img src="{{ URL::to('/') }}/images/{{ Session::get('photo') }}" class="img-circle" alt="">
                    <i class="on border-dark animated bounceIn"></i>
                </div>
                <div class="profile-body dropdown">
                    <a href="javascript:void(0);" class="dropdown-toggle"><h4>{{ Session::get('name') }}</h4></a>
                    <small class="title">Superadmin</small>
                </div>
            </div>
            <nav>
                <h5 class="sidebar-header">Navigation</h5>
                <ul class="nav nav-pills nav-stacked">
                    <li class="active">
                        <a href="{{ url('/admin/dashboard') }}" title="Dashboard">
                            <i class="fa  fa-fw fa-tachometer"></i> Dashboard
                        </a>
                    </li>
                    <li>
                        <a href="{{url('/admin/servicerequest')}}" title="Service Request">
                            <i class="fa fa-fw fa-bell-o"></i> Service Request
                        </a>
                    </li>
                    <li>
                        <a href="{{url('/admin/requestforgrainseeds')}}" title="Request For Grain/Seeds">
                            <i class="fa fa-fw fa-external-link-square"></i> Request For Grain/Seeds
                        </a>
                    </li>
                    <li class="nav-dropdown">
                        <a href="#" title="UI Elements">
                            <i class="fa  fa-fw fa-inr"></i> Request For Cash
                        </a>
                        <ul class="nav-sub">
							<li>
								<a href="{{url('/admin/requestforcashkishan')}}" title="Request For Cash Kishan">
									Kishan
								</a>
							</li>
							<li>
								<a href="{{url('/admin/requestforcashvender')}}" title="Request For Cash Vender">
									Vender
								</a>
							</li>
						</ul>
                    </li>
                    <li class="nav-dropdown">
                        <a href="#" title="UI Elements">
                            <i class="fa  fa-fw fa-users"></i> Users
                        </a>
                        <ul class="nav-sub">
                            <li>
                                <a href="{{ url('/admin/kishan') }}" title="Kishan">
                                     Kishan
                                </a>
                            </li>
                            <li>
                                <a href="{{ url('/admin/vender') }}" title="Vender">
                                     Vender
                                </a>
                            </li>
                            <li>
                                <a href="{{ url('/admin/experts') }}" title="Experts">
                                     Experts
                                </a>
                            </li>
                            <li>
                                <a href="{{ url('/admin/buyer') }}" title="Buyer">
                                     Buyer
                                </a>
                            </li>
                        </ul>
                    </li>
                    <li >
                        <a href="{{url('/admin/grainseeds')}}" title="Grain/Seeds">
                            <i class="fa fa-fw fa-pagelines"></i> Grain/Seeds
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/category')}}" title="Category">
                            <i class="fa fa-fw fa-th-large "></i> Category
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/subcategory')}}" title="Sub Category">
                            <i class="fa fa-fw fa-th-large "></i> Sub Category
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/shoptype')}}" title="Shop Type">
                            <i class="fa fa-fw fa-building"></i> Shop Type
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/banner')}}" title="Banner">
                            <i class="fa fa-fw fa-image "></i> Banner
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/services')}}" title="Services">
                            <i class="fa fa-fw fa-list"></i> Services
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/information')}}" title="Information">
                            <i class="fa fa-fw fa-info-circle"></i> Information
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/policy/1')}}" title="Policy">
                            <i class="fa fa-fw fa-file"></i> Policy
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/news')}}" title="News">
                            <i class="fa fa-fw fa-newspaper-o"></i> News
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/logout')}}" title="Logout">
                            <i class="fa fa-fw fa-sign-out"></i> Logout
                        </a>
                    </li>
                </ul>
            </nav>
        </aside>
        <!--sidebar left end-->
        <!--main content start-->
        <section class="main-content-wrapper">
            <div class="pageheader dark">
                <h1>Dashboard</h1>
                <div class="breadcrumb-wrapper hidden-xs">
                    <ol class="breadcrumb">
                        <li class="active">Dashboard</li>
                    </ol>
                </div>
            </div>
            <section id="main-content" class="animated fadeInUp">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                            <div class="col-md-2">
                                <a href="{{ url('/admin/requestforcashkishan') }}">
									<div class="panel widget-mini">
										<div class="panel-body bg-0 border-radius">
											<i class="fa fa-wa fa-inr"></i>
											<span class="total text-center">{{ $requestforcashkishan }}</span>
											<span class="title text-center">Request For Cash Kishan</span>
										</div>
									</div>
								</a>
                            </div>
                            <div class="col-md-2">
                                <a href="{{ url('/admin/requestforcashvender') }}">
									<div class="panel widget-mini">
										<div class="panel-body bg-1 border-radius">
											<i class="fa fa-wa fa-inr"></i>
											<span class="total text-center">{{ $requestforcashvender }}</span>
											<span class="title text-center">Request For Cash Vender</span>
										</div>
									</div>
								</a>
                            </div>
                            <div class="col-md-2">
                                <a href="{{ url('/admin/requestforgrainseeds') }}">
									<div class="panel widget-mini">
										<div class="panel-body bg-2 border-radius">
											<i class="fa fa-wa fa-external-link-square"></i>
											<span class="total text-center">{{ $coustomerenquiry }}</span>
											<span class="title text-center">Request For Grain/Seeds</span>
										</div>
									</div>
								</a>
                            </div>
                            <div class="col-md-2">
                                <a href="{{ url('/admin/todayservicerequest') }}">
									<div class="panel widget-mini">
										<div class="panel-body bg-3 border-radius">
											<i class="fa fa-wa fa-bell-o"></i>
											<span class="total text-center">{{ $todayservicerequest }}</span>
											<span class="title text-center">Today Service Request</span>
										</div>
									</div>
								</a>
                            </div>
                            <div class="col-md-2">
                                <a href="{{ url('/admin/unassignedservicerequest') }}">
									<div class="panel widget-mini">
										<div class="panel-body bg-4 border-radius">
											<i class="fa fa-wa fa-bell-o"></i>
											<span class="total text-center">{{ $unassignedservicerequest }}</span>
											<span class="title text-center">Unassigned Service Request</span>
										</div>
									</div>
								</a>
                            </div>
                            <div class="col-md-2">
                                <a href="{{ url('/admin/assignedservicerequest') }}">
									<div class="panel widget-mini">
										<div class="panel-body bg-5 border-radius">
											<i class="fa fa-wa fa-bell-o"></i>
											<span class="total text-center">{{ $assignedservicerequest }}</span>
											<span class="title text-center">Assigned Service Request</span>
										</div>
									</div>
								</a>
                            </div>
						</div>
                        <div class="row">
                            <div class="col-md-2">
                                <a href="{{ url('/admin/kishan') }}">
									<div class="panel widget-mini">
										<div class="panel-body bg-0 border-radius">
											<i class="fa fa-wa fa-user"></i>
											<span class="total text-center">{{ $kishan }}</span>
											<span class="title text-center">Kishan</span>
										</div>
									</div>
								</a>
                            </div>
                            <div class="col-md-2">
                                <a href="{{ url('/admin/vender') }}">
									<div class="panel widget-mini">
										<div class="panel-body bg-1 border-radius">
											<i class="fa fa-wa fa-building"></i>
											<span class="total text-center">{{ $vender }}</span>
											<span class="title text-center">Vender</span>
										</div>
									</div>
								</a>
                            </div>
                            <div class="col-md-2">
                                <a href="{{ url('/admin/buyer') }}">
									<div class="panel widget-mini">
										<div class="panel-body bg-2 border-radius">
											<i class="fa fa-wa fa-users"></i>
											<span class="total text-center">{{ $buyer }}</span>
											<span class="title text-center">Buyer</span>
										</div>
									</div>
								</a>
                            </div>
                            <div class="col-md-2">
                                <a href="{{ url('/admin/experts') }}">
                                <div class="panel widget-mini">
										<div class="panel-body bg-3 border-radius">
											<i class="fa fa-fw fa-video-camera"></i>
											<span class="total text-center">{{ $expert }}</span>
											<span class="title text-center">Experts</span>
										</div>
									</div>
								</a>
                            </div>
                            <div class="col-md-2">
                                <a href="{{url('/admin/grainseeds')}}">
                                <div class="panel widget-mini">
										<div class="panel-body bg-4 border-radius">
											<i class="fa fa-fw fa-pagelines"></i>
											<span class="total text-center">{{ $no_of_seeds }}</span>
											<span class="title text-center">Grain/Seeds</span>
										</div>
									</div>
								</a>
                            </div>
                            <div class="col-md-2">
                                <a href="{{url('/admin/category')}}">
                                <div class="panel widget-mini">
										<div class="panel-body bg-5 border-radius">
											<i class="fa fa-fw fa-th"></i>
											<span class="total text-center">{{ $no_of_category }}</span>
											<span class="title text-center">Categories</span>
										</div>
									</div>
								</a>
                            </div>
                            <div class="col-md-2">
                                <a href="{{url('/admin/subcategory')}}">
                                <div class="panel widget-mini">
										<div class="panel-body bg-6 border-radius">
											<i class="fa fa-fw fa-th"></i>
											<span class="total text-center">{{ $no_of_sub_category }}</span>
											<span class="title text-center">Sub Categories</span>
										</div>
									</div>
								</a>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </section>
        <!--main content end-->
    </section>
@endsection     