@extends('admin.layouts.app')

@section('content')
    <section id="main-wrapper" class="theme-dark-full">
        <header id="header">
            <!--logo start-->
            <div class="brand">
                <a href="{{ url('/admin/dashboard') }}" class="logo">
                    <span>{{ Session::get('name') }}</span>
				</a>
            </div>
            <!--logo end-->
            <ul class="nav navbar-nav navbar-left">
                <li class="toggle-navigation toggle-left">
                    <button class="sidebar-toggle" id="toggle-left">
                        <i class="fa fa-bars"></i>
                    </button>
                </li>
            </ul>
            <ul class="nav navbar-nav navbar-right">
                <li class="dropdown profile hidden-xs">
                    <a href="javascript:void(0);" class="dropdown-toggle" data-toggle="dropdown">
                        <span class="meta">
                            <span class="avatar">
                                <img src="{{ URL::to('/') }}/images/{{ Session::get('photo') }}" class="img-circle" alt="">
                            </span>
                        <span class="text">{{ Session::get('name') }}</span>
                        <span class="caret"></span>
                        </span>
                    </a>
                    <ul class="dropdown-menu animated fadeInRight" role="menu">
                        <li>
                            <a href="{{url('/admin/profile')}}/{{ Session::get('id') }}">
                                <span class="icon"><i class="fa fa-user"></i>
                                </span>Profile</a>
                        </li>
                        <li>
                            <a href="{{url('admin/changepassword')}}/{{ Session::get('id') }}">
                                <span class="icon"><i class="fa fa-lock"></i>
                                </span>Change Password</a>
                        </li>
                        <li class="divider"></li>
                        <li>
                            <a href="{{url('/admin/logout')}}">
                                <span class="icon"><i class="fa fa-sign-out"></i>
                                </span>Logout</a>
                        </li>                    </ul>
                </li>
                <li class="toggle-fullscreen hidden-xs">
                    <button type="button" class="btn btn-default expand" id="toggle-fullscreen">
                        <i class="fa fa-expand"></i>
                    </button>
                </li>
            </ul>
        </header>
        <!--sidebar left start-->
        <aside class="sidebar sidebar-left">
            <div class="sidebar-profile">
                <div class="avatar">
                    <img src="{{ URL::to('/') }}/images/{{ Session::get('photo') }}" class="img-circle" alt="">
                    <i class="on border-dark animated bounceIn"></i>
                </div>
                <div class="profile-body dropdown">
                    <a href="javascript:void(0);" class="dropdown-toggle"><h4>{{ Session::get('name') }}</h4></a>
                    <small class="title">Superadmin</small>
                </div>
            </div>
            <nav>
                <h5 class="sidebar-header">Navigation</h5>
                <ul class="nav nav-pills nav-stacked">
                    <li>
                        <a href="{{ url('/admin/dashboard') }}" title="Dashboard">
                            <i class="fa  fa-fw fa-tachometer"></i> Dashboard
                        </a>
                    </li>
                    <li>
                        <a href="{{url('/admin/servicerequest')}}" title="Service Request">
                            <i class="fa fa-fw fa-bell-o"></i> Service Request
                        </a>
                    </li>
                    <li>
                        <a href="{{url('/admin/requestforgrainseeds')}}" title="Request For Grain/Seeds">
                            <i class="fa fa-fw fa-external-link-square"></i> Request For Grain/Seeds
                        </a>
                    </li>
                    <li class="nav-dropdown">
                        <a href="#" title="UI Elements">
                            <i class="fa  fa-fw fa-inr"></i> Request For Cash
                        </a>
                        <ul class="nav-sub">
							<li>
								<a href="{{url('/admin/requestforcashkishan')}}" title="Request For Cash Kishan">
									Kishan
								</a>
							</li>
							<li>
								<a href="{{url('/admin/requestforcashvender')}}" title="Request For Cash Vender">
									Vender
								</a>
							</li>
						</ul>
                    </li>
                    
					<li class="nav-dropdown open active">
                        <a href="#" title="UI Elements">
                            <i class="fa  fa-fw fa-users"></i> Users
                        </a>
                        <ul class="nav-sub">
                            <li>
                                <a href="{{ url('/admin/kishan') }}" title="Kishan">
                                     Kishan
                                </a>
                            </li>
                            <li>
                                <a href="{{ url('/admin/vender') }}" title="Vender">
                                     Vender
                                </a>
                            </li>
                            <li class="active">
                                <a href="{{ url('/admin/experts') }}" title="Experts">
                                     Experts
                                </a>
                            </li>
                            <li>
                                <a href="{{ url('/admin/buyer') }}" title="Buyer">
                                     Buyer
                                </a>
                            </li>
                        </ul>
                    </li>
                    <li >
                        <a href="{{url('/admin/grainseeds')}}" title="Grain/Seeds">
                            <i class="fa fa-fw fa-pagelines"></i> Grain/Seeds
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/category')}}" title="Category">
                            <i class="fa fa-fw fa-th-large "></i> Category
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/subcategory')}}" title="Sub Category">
                            <i class="fa fa-fw fa-th-large "></i> Sub Category
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/shoptype')}}" title="Shop Type">
                            <i class="fa fa-fw fa-building"></i> Shop Type
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/banner')}}" title="Banner">
                            <i class="fa fa-fw fa-image "></i> Banner
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/services')}}" title="Services">
                            <i class="fa fa-fw fa-list"></i> Services
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/information')}}" title="Information">
                            <i class="fa fa-fw fa-info-circle"></i> Information
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/policy/1')}}" title="Policy">
                            <i class="fa fa-fw fa-file"></i> Policy
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/news')}}" title="News">
                            <i class="fa fa-fw fa-newspaper-o"></i> News
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/logout')}}" title="Logout">
                            <i class="fa fa-fw fa-sign-out"></i> Logout
                        </a>
                    </li>
                </ul>
            </nav>
        </aside>
        <!--sidebar left end-->
        <!--main content start-->
        <section class="main-content-wrapper">
            <div class="pageheader dark">
                <h1>Experts</h1>
                <div class="breadcrumb-wrapper hidden-xs">
                    <ol class="breadcrumb">
                        <li><a href="{{url('/admin/addexpert')}}" class="cusotm-btn">Add Experts</a></li>
                    </ol>
                </div>
            </div>
            <section id="main-content" class="animated fadeInUp">
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-default">
                            <div class="panel-body">

								@if (Session::get('success')) 
									<div class="alert alert-success alert-dismissable">
										<button type="button" class="close" data-dismiss="alert" aria-hidden="true">x</button>
										{{ Session::get('success') }}                                    
									</div>
								@endif

                                <table id="example" class="table table-striped table-bordered" cellspacing="0" width="100%">
                                    <thead>
                                        <tr>
                                            <th width="3%">#</th>
                                            <th width="13%">Name</th>
                                            <th width="10%">Contact No.</th>
                                            <th width="12%">Email</th>
                                            <th>Address</th>
                                            <th width="10%">City</th>
                                            <th width="10%">District</th>
                                            <th width="10%">State</th>
                                            <th width="6%">Pincode</th>
                                            <th width="5%">Action</th>
                                        </tr>
                                    </thead>

                                    <tbody>									
									@foreach($data as $key => $item)
                                        <tr>
                                            <td class="p-0"><a href="{{url('/admin/viewexpertdetail')}}/{{$item->id}}" class="td-link"><b>{{ ++$key }}.</b></a></td>
                                            <td class="p-0"><a href="{{url('/admin/viewexpertdetail')}}/{{$item->id}}" class="td-link">{{ $item->userName }} @if($item->kycVerifiedStatus == 'Verified') <img src="{{ asset('admin/assets/img/verified-1.png') }}"/> @elseif($item->kycVerifiedStatus == 'Rejected') <img src="{{ asset('admin/assets/img/rejected-1.png') }}"/>@endif</a></td>
                                            <td class="p-0"><a href="{{url('/admin/viewexpertdetail')}}/{{$item->id}}" class="td-link">{{ $item->userMobile }}</a></td>
                                            <td class="p-0"><a href="{{url('/admin/viewexpertdetail')}}/{{$item->id}}" class="td-link">{{ $item->userEmail }}</a></td>
                                            <td class="p-0"><a href="{{url('/admin/viewexpertdetail')}}/{{$item->id}}" class="td-link">{{ $item->userLocation }}</a></td>
                                            <td class="p-0"><a href="{{url('/admin/viewexpertdetail')}}/{{$item->id}}" class="td-link">{{ $item->city }}</a></td>
                                            <td class="p-0"><a href="{{url('/admin/viewexpertdetail')}}/{{$item->id}}" class="td-link">{{ $item->district }}</a></td>
                                            <td class="p-0"><a href="{{url('/admin/viewexpertdetail')}}/{{$item->id}}" class="td-link">{{ $item->state }}</a></td>
                                            <td class="p-0"><a href="{{url('/admin/viewexpertdetail')}}/{{$item->id}}" class="td-link">{{ $item->pincode }}</a></td>
                                            <td>
                                                <a href="{{url('/admin/updateexpert')}}/{{$item->id}}" class="action-btn"><i class="fa fa-pencil-square-o green-btn" title="Edit"></i></a>
                                                <form method="post" action="{{url('/admin/deleteexpert')}}">
                                                    @csrf
                                                    <input type="hidden" value="{{$item->id}}" name="id">
                                                    <button type="submit" class="action-btn"><i class="fa fa-trash red-btn" title="Delete"></i></button>
                                                </form>
											</td>
                                        </tr>
									@endforeach
                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </section>
        <!--main content end-->
    </section>
@endsection     