@extends('admin.layouts.app')

@section('content')
  <section class="animated fadeInUp">
    <div class="container">
        <div class="row">
            <div class="col-md-4 col-md-offset-4">
                <div id="login-wrapper">
                    <div class="panel panel-primary">
                        <div class="panel-heading">
                            <h3 class="panel-title">     
                           Login
                        </h3>
                        </div>
                        <div class="panel-body">
                            <p> Login to access your account.</p>

                            @if (Session::get('error')) 
                                <div class="alert alert-danger alert-dismissable">
                                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                    <strong><i class="fa fa-frown-o" aria-hidden="true"></i> </strong>{{ Session::get('error') }}                                    
                                </div>
                            @endif

                            <form class="form-horizontal" role="form" action="admin/login" method="post">
                                @csrf
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <input type="hidden" class="form-control" id="type" name="type" value="admin" required> 
                                        <input type="text" class="form-control" id="email" name="username" placeholder="Username" required> 
                                        <i class="fa fa-user"></i>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <input type="password" class="form-control" id="password" name="password" placeholder="Password" required>
                                        <i class="fa fa-lock"></i>
										<span toggle="#password" class="fa fa-eye-slash field-icon new-password"></span>
                                    </div>
                                </div>
                                <div class="form-group mb-0">
                                    <div class="text-center">
                                        <button type="submit" class="btn btn-primary btn-block">Login</button>
                                        <!--<a href="{{url('forgotpassword')}}" class="font-12 mt-10">Forgot Password?</a>-->
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
      </div>  
    </section>
@endsection     