@extends('admin.layouts.app')

@section('content')
    <section id="main-wrapper" class="theme-dark-full">
        <header id="header">
            <!--logo start-->
            <div class="brand">
                <a href="{{ url('/admin/dashboard') }}" class="logo">
                    <span>{{ Session::get('name') }}</span>
				</a>
            </div>
            <!--logo end-->
            <ul class="nav navbar-nav navbar-left">
                <li class="toggle-navigation toggle-left">
                    <button class="sidebar-toggle" id="toggle-left">
                        <i class="fa fa-bars"></i>
                    </button>
                </li>
            </ul>
            <ul class="nav navbar-nav navbar-right">
                <li class="dropdown profile hidden-xs">
                    <a href="javascript:void(0);" class="dropdown-toggle" data-toggle="dropdown">
                        <span class="meta">
                            <span class="avatar">
                                <img src="{{ URL::to('/') }}/images/{{ Session::get('photo') }}" class="img-circle" alt="">
                            </span>
                        <span class="text">{{ Session::get('name') }}</span>
                        <span class="caret"></span>
                        </span>
                    </a>
                    <ul class="dropdown-menu animated fadeInRight" role="menu">
                        <li>
                            <a href="{{url('/admin/profile')}}/{{ Session::get('id') }}">
                                <span class="icon"><i class="fa fa-user"></i>
                                </span>Profile</a>
                        </li>
                        <li>
                            <a href="{{url('admin/changepassword')}}/{{ Session::get('id') }}">
                                <span class="icon"><i class="fa fa-lock"></i>
                                </span>Change Password</a>
                        </li>
                        <li class="divider"></li>
                        <li>
                            <a href="{{url('/admin/logout')}}">
                                <span class="icon"><i class="fa fa-sign-out"></i>
                                </span>Logout</a>
                        </li>                    </ul>
                </li>
                <li class="toggle-fullscreen hidden-xs">
                    <button type="button" class="btn btn-default expand" id="toggle-fullscreen">
                        <i class="fa fa-expand"></i>
                    </button>
                </li>
            </ul>
        </header>
        <!--sidebar left start-->
        <aside class="sidebar sidebar-left">
            <div class="sidebar-profile">
                <div class="avatar">
                    <img src="{{ URL::to('/') }}/images/{{ Session::get('photo') }}" class="img-circle" alt="">
                    <i class="on border-dark animated bounceIn"></i>
                </div>
                <div class="profile-body dropdown">
                    <a href="javascript:void(0);" class="dropdown-toggle"><h4>{{ Session::get('name') }}</h4></a>
                    <small class="title">Superadmin</small>
                </div>
            </div>
            <nav>
                <h5 class="sidebar-header">Navigation</h5>
                <ul class="nav nav-pills nav-stacked">
                    <li>
                        <a href="{{ url('/admin/dashboard') }}" title="Dashboard">
                            <i class="fa  fa-fw fa-tachometer"></i> Dashboard
                        </a>
                    </li>
                    <li>
                        <a href="{{url('/admin/servicerequest')}}" title="Service Request">
                            <i class="fa fa-fw fa-bell-o"></i> Service Request
                        </a>
                    </li>
                    <li>
                        <a href="{{url('/admin/requestforgrainseeds')}}" title="Request For Grain/Seeds">
                            <i class="fa fa-fw fa-external-link-square"></i> Request For Grain/Seeds
                        </a>
                    </li>
                    <li class="nav-dropdown">
                        <a href="#" title="UI Elements">
                            <i class="fa  fa-fw fa-inr"></i> Request For Cash
                        </a>
                        <ul class="nav-sub">
							<li>
								<a href="{{url('/admin/requestforcashkishan')}}" title="Request For Cash Kishan">
									Kishan
								</a>
							</li>
							<li>
								<a href="{{url('/admin/requestforcashvender')}}" title="Request For Cash Vender">
									Vender
								</a>
							</li>
						</ul>
                    </li>
                    <li class="nav-dropdown open active">
                        <a href="#" title="UI Elements">
                            <i class="fa  fa-fw fa-users"></i> Users
                        </a>
                        <ul class="nav-sub">
                            <li>
                                <a href="{{ url('/admin/kishan') }}" title="Kishan">
                                     Kishan
                                </a>
                            </li>
                            <li>
                                <a href="{{ url('/admin/vender') }}" title="Vender">
                                     Vender
                                </a>
                            </li>
                            <li>
                                <a href="{{ url('/admin/experts') }}" title="Experts">
                                     Experts
                                </a>
                            </li>
                            <li class="active">
                                <a href="{{ url('/admin/buyer') }}" title="Buyer">
                                     Buyer
                                </a>
                            </li>
                        </ul>
                    </li>
                    <li >
                        <a href="{{url('/admin/grainseeds')}}" title="Grain/Seeds">
                            <i class="fa fa-fw fa-pagelines"></i> Grain/Seeds
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/category')}}" title="Category">
                            <i class="fa fa-fw fa-th-large "></i> Category
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/subcategory')}}" title="Sub Category">
                            <i class="fa fa-fw fa-th-large "></i> Sub Category
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/shoptype')}}" title="Shop Type">
                            <i class="fa fa-fw fa-building"></i> Shop Type
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/banner')}}" title="Banner">
                            <i class="fa fa-fw fa-image "></i> Banner
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/services')}}" title="Services">
                            <i class="fa fa-fw fa-list"></i> Services
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/information')}}" title="Information">
                            <i class="fa fa-fw fa-info-circle"></i> Information
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/policy/1')}}" title="Policy">
                            <i class="fa fa-fw fa-file"></i> Policy
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/news')}}" title="News">
                            <i class="fa fa-fw fa-newspaper-o"></i> News
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/logout')}}" title="Logout">
                            <i class="fa fa-fw fa-sign-out"></i> Logout
                        </a>
                    </li>
                </ul>
            </nav>
        </aside>
        <!--sidebar left end-->
        <!--main content start-->
        <section class="main-content-wrapper">
            <div class="pageheader dark">
                <h1>Edit Buyer</h1>
                <div class="breadcrumb-wrapper hidden-xs">
                    <ol class="breadcrumb">
                        <li><a href="{{url('/admin/buyer')}}" class="cusotm-btn">All Buyer</a></li>
                    </ol>
                </div>
            </div>
            <section id="main-content" class="animated fadeInUp">
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-default">
                            <div class="panel-body">

								@if(count($errors) > 0)
									@foreach($errors->all() as $error)
										<div class="alert alert-danger alert-dismissable m-0">
											<button type="button" class="close" data-dismiss="alert" aria-hidden="true">x</button>
											{{ str_replace('1024 kilobytes','1MB',$error) }}                                 
										</div>
									@endforeach
								@endif


                                <form class="form-horizontal form-border" method="post" action="{{url('/admin/updatebuyer')}}" enctype="multipart/form-data">
									@csrf
									<input type="hidden" name="id" value="{{ $data->id}}">
                                    <div class="form-group">
                                        <div class="col-sm-3">
											<label class="control-label">Name <span class="red-btn">*</span></label>
                                            <input type="text" name="userName" class="form-control" value="{{ $data->userName }}" required>
                                        </div>
                                        <div class="col-sm-2">
											<label class="control-label">Contact No. <span class="red-btn">*</span></label>
                                            <input type="text" name="userMobile" class="form-control" value="{{ $data->userMobile }}" pattern="[9876][0-9]+" title="Number Only" required>
                                        </div>
                                        <div class="col-sm-3">
											<label class="control-label">E-mail</label>
                                            <input type="text" name="userEmail" value="{{ $data->userEmail }}" class="form-control">
                                        </div>
                                        <div class="col-sm-2">
											<label class="control-label">Gender</label>
                                            <select name="gender" class="form-control">
												<option value="">Select</option>
												<option value="M" @if($data->gender == 'M') selected @endif>Male</option>
												<option value="F" @if($data->gender == 'F') selected @endif>Female</option>
												<option value="O" @if($data->gender == 'O') selected @endif>Other</option>
											</select>
                                        </div>
                                        <div class="col-sm-2">
											<label class="control-label">Age</label>
                                            <input type="text" name="age" class="form-control" value="{{ $data->age }}" pattern="[0-9]{2}" title="Number Only">
                                        </div>
                                        <div class="col-sm-3">
											<label class="control-label">Address <span class="red-btn">*</span></label>
                                            <input type="text" name="userLocation" class="form-control" value="{{ $data->userLocation }}" required>
                                        </div>
                                        <div class="col-sm-2">
											<label class="control-label">City <span class="red-btn">*</span></label>
                                            <input type="text" name="city" class="form-control" value="{{ $data->city }}" required>
                                        </div>
                                        <div class="col-sm-2">
											<label class="control-label">District <span class="red-btn">*</span></label>
                                            <input type="text" name="district" class="form-control" value="{{ $data->district }}" required>
                                        </div>
                                        <div class="col-sm-2">
											<label class="control-label">State <span class="red-btn">*</span></label>
                                            <select name="state" class="form-control" required>
												<option value="">Select</option>
												<option value="Andhra Pradesh" {{ $data->state === 'Andhra Pradesh' ? 'selected' : '' }}>Andhra Pradesh</option>
												<option value="Arunachal Pradesh" {{ $data->state === 'Arunachal Pradesh' ? 'selected' : '' }}>Arunachal Pradesh</option>
												<option value="Andaman and Nicobar Islands" {{ $data->state === 'Andaman and Nicobar Islands' ? 'selected' : '' }}>Andaman and Nicobar Islands</option>
												<option value="Assam" {{ $data->state === 'Assam' ? 'selected' : '' }}>Assam</option>
												<option value="Bihar" {{ $data->state === 'Bihar' ? 'selected' : '' }}>Bihar</option>
												<option value="Chandigarh" {{ $data->state === 'Chandigarh' ? 'selected' : '' }}>Chandigarh</option>
												<option value="Chhattisgarh" {{ $data->state === 'Chhattisgarh' ? 'selected' : '' }}>Chhattisgarh</option>
												<option value="Dadra and Nagar Haveli and Daman & Diu" {{ $data->state === 'Dadra and Nagar Haveli and Daman & Diu' ? 'selected' : '' }}>Dadra and Nagar Haveli and Daman & Diu</option>
												<option value="Delhi" {{ $data->state === 'Delhi' ? 'selected' : '' }}>Delhi</option>
												<option value="Goa" {{ $data->state === 'Goa' ? 'selected' : '' }}>Goa</option>
												<option value="Gujarat" {{ $data->state === 'Gujarat' ? 'selected' : '' }}>Gujarat</option>
												<option value="Haryana" {{ $data->state === 'Haryana' ? 'selected' : '' }}>Haryana</option>
												<option value="Himachal Pradesh" {{ $data->state === 'Himachal Pradesh' ? 'selected' : '' }}>Himachal Pradesh</option>
												<option value="Jharkhand" {{ $data->state === 'Jharkhand' ? 'selected' : '' }}>Jharkhand</option>
												<option value="Jammu & Kashmir" {{ $data->state === 'Jammu & Kashmir' ? 'selected' : '' }}>Jammu & Kashmir</option>
												<option value="Karnataka" {{ $data->state === 'Karnataka' ? 'selected' : '' }}>Karnataka</option>
												<option value="Kerala" {{ $data->state === 'Kerala' ? 'selected' : '' }}>Kerala</option>
												<option value="Ladakh" {{ $data->state === 'Ladakh' ? 'selected' : '' }}>Ladakh</option>
												<option value="Lakshadweep" {{ $data->state === 'Lakshadweep' ? 'selected' : '' }}>Lakshadweep</option>
												<option value="Madhya Pradesh" {{ $data->state === 'Madhya Pradesh' ? 'selected' : '' }}>Madhya Pradesh</option>
												<option value="Maharashtra" {{ $data->state === 'Maharashtra' ? 'selected' : '' }}>Maharashtra</option>
												<option value="Manipur" {{ $data->state === 'Manipur' ? 'selected' : '' }}>Manipur</option>
												<option value="Meghalaya" {{ $data->state === 'Meghalaya' ? 'selected' : '' }}>Meghalaya</option>
												<option value="Mizoram" {{ $data->state === 'Mizoram' ? 'selected' : '' }}>Mizoram</option>
												<option value="Nagaland" {{ $data->state === 'Nagaland' ? 'selected' : '' }}>Nagaland</option>
												<option value="Odisha" {{ $data->state === 'Odisha' ? 'selected' : '' }}>Odisha</option>
												<option value="Punjab" {{ $data->state === 'Punjab' ? 'selected' : '' }}>Punjab</option>
												<option value="Puducherry" {{ $data->state === 'Puducherry' ? 'selected' : '' }}>Puducherry</option>
												<option value="Rajasthan" {{ $data->state === 'Rajasthan' ? 'selected' : '' }}>Rajasthan</option>
												<option value="Sikkim" {{ $data->state === 'Sikkim' ? 'selected' : '' }}>Sikkim</option>
												<option value="Tamil Nadu" {{ $data->state === 'Tamil Nadu' ? 'selected' : '' }}>Tamil Nadu</option>
												<option value="Telangana" {{ $data->state === 'Telangana' ? 'selected' : '' }}>Telangana</option>
												<option value="Tripura" {{ $data->state === 'Tripura' ? 'selected' : '' }}>Tripura</option>
												<option value="Uttarakhand" {{ $data->state === 'Uttarakhand' ? 'selected' : '' }}>Uttarakhand</option>
												<option value="Uttar Pradesh" {{ $data->state === 'Uttar Pradesh' ? 'selected' : '' }}>Uttar Pradesh</option>
												<option value="West Bengal" {{ $data->state === 'West Bengal' ? 'selected' : '' }}>West Bengal</option>
											</select>
										</div>
                                        <div class="col-sm-1">
											<label class="control-label">Pincode <span class="red-btn">*</span></label>
                                            <input type="text" name="pincode" class="form-control" value="{{ $data->pincode }}" pattern="[0-9]{6}" title="Number Only" required>
                                        </div>
                                        <div class="col-sm-2">
											<label class="control-label">Password</label>
                                            <input type="password" name="userPassword" class="form-control">
                                        </div>
                                        <div class="col-sm-12">
											<button type="submit" class="btn btn-primary mt-20">Save</button>
										</div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </section>
        <!--main content end-->
    </section>
@endsection     