<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\VenderController;
use App\Http\Controllers\ExpertsController;
use App\Http\Controllers\BuyerController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\SubCategoryController;
use App\Http\Controllers\ShopTypeController;
use App\Http\Controllers\BannerController;
use App\Http\Controllers\NewsController;
use App\Http\Controllers\ServicesController;
use App\Http\Controllers\InformationController;
use App\Http\Controllers\PolicyController;
use App\Http\Controllers\ServiceRequestController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

	//Admin Panel Routes

	Route::group(['middleware' => "admin"], function(){

		// Route Admin
		Route::get('panel', [AdminController::class,'index']);
		Route::post('/admin/login', [AdminController::class,'login']);
		Route::get('/admin/dashboard', [AdminController::class,'dashboard']);
		Route::get('/admin/profile/{id}',[AdminController::class,'Profile']);
		Route::post('/admin/profile',[AdminController::class,'Save']);
		Route::get('admin/changepassword/{id}',[AdminController::class,'ChangePassword']);
		Route::post('admin/changepassword',[AdminController::class,'ChangePasswordSave']);

		// Route Kishan
		Route::get('/admin/kishan', [UserController::class,'Kishan']);
		Route::get('/admin/addkishan',[UserController::class,'addKishan']);
		Route::post('/admin/addkishan',[UserController::class,'AddKishanData']);
		Route::post('/admin/deletekishan',[UserController::class,'DeleteKishan']);
		Route::get('/admin/updatekishan/{id}',[UserController::class,'UpdateKishan']);
		Route::post('/admin/updatekishan',[UserController::class,'Save']);
		Route::get('/admin/viewkishandetail/{id}',[UserController::class,'ViewKishanDetail']);
		Route::post('/admin/updatekycstatus',[UserController::class,'UpdateKYCStatus']);
		Route::get('/admin/kishantransactionhistory/{id}',[UserController::class,'ViewKishanTransactionHistory']);
		Route::get('/admin/addkishancredit/{id}',[UserController::class,'KishanCredit']);
		Route::post('/admin/addkishancredit',[UserController::class,'AddKishanCredit']);


		// Route Vender
		Route::get('/admin/vender', [VenderController::class,'Vender']);
		Route::get('/admin/addvender',[VenderController::class,'addVender']);
		Route::post('/admin/addvender',[VenderController::class,'AddVenderData']);
		Route::post('/admin/deletevender',[VenderController::class,'DeleteVender']);
		Route::get('/admin/updatevender/{id}',[VenderController::class,'UpdateVender']);
		Route::post('/admin/updatevender',[VenderController::class,'Save']);
		Route::get('/admin/viewvenderdetail/{id}',[VenderController::class,'ViewVenderDetail']);
		Route::post('/admin/updatevenderkycstatus',[VenderController::class,'UpdateKYCStatus']);
		Route::get('/admin/vendertransactionhistory/{id}',[VenderController::class,'ViewVenderTransactionHistory']);
		Route::get('/admin/addvendercredit/{id}',[VenderController::class,'VenderCredit']);
		Route::post('/admin/addvendercredit',[VenderController::class,'AddVenderCredit']);

		// Route Experts
		Route::get('/admin/experts', [ExpertsController::class,'Experts']);
		Route::get('/admin/addexpert',[ExpertsController::class,'addExpert']);
		Route::post('/admin/addexpert',[ExpertsController::class,'AddExpertData']);
		Route::post('/admin/deleteexpert',[ExpertsController::class,'DeleteExpert']);
		Route::get('/admin/updateexpert/{id}',[ExpertsController::class,'UpdateExpert']);
		Route::post('/admin/updateexpert',[ExpertsController::class,'Save']);
		Route::get('/admin/viewexpertdetail/{id}',[ExpertsController::class,'ViewExpertDetail']);
		Route::post('/admin/updateexpertkycstatus',[ExpertsController::class,'UpdateKYCStatus']);

		// Route Buyer
		Route::get('/admin/buyer', [BuyerController::class,'Buyer']);
		Route::get('/admin/addbuyer',[BuyerController::class,'addBuyer']);
		Route::post('/admin/addbuyer',[BuyerController::class,'AddBuyerData']);
		Route::post('/admin/deletebuyer',[BuyerController::class,'DeleteBuyer']);
		Route::get('/admin/updatebuyer/{id}',[BuyerController::class,'UpdateBuyer']);
		Route::post('/admin/updatebuyer',[BuyerController::class,'Save']);
		Route::get('/admin/viewbuyerdetail/{id}',[BuyerController::class,'ViewBuyerDetail']);

		// Route Category
		Route::get('/admin/category', [CategoryController::class,'AllCategory']);
		Route::get('/admin/addcategory',[CategoryController::class,'AddCategory']);
		Route::post('/admin/addcategory',[CategoryController::class,'AddCategoryData']);
		Route::post('/admin/activecategory',[CategoryController::class,'ActiveCategory']);
		Route::post('/admin/deactivecategory',[CategoryController::class,'DeactiveCategory']);
		Route::post('/admin/deletecategory',[CategoryController::class,'DeleteCategory']);
		Route::get('/admin/updatecategory/{id}',[CategoryController::class,'UpdateCategory']);
		Route::post('/admin/updatecategory',[CategoryController::class,'Save']);

		// Route Sub Category
		Route::get('/admin/subcategory', [SubCategoryController::class,'AllSubCategory']);
		Route::get('/admin/addsubcategory',[SubCategoryController::class,'AddSubCategory']);
		Route::post('/admin/addsubcategory',[SubCategoryController::class,'AddSubCategoryData']);
		Route::post('/admin/activesubcategory',[SubCategoryController::class,'ActiveSubCategory']);
		Route::post('/admin/deactivesubcategory',[SubCategoryController::class,'DeactiveSubCategory']);
		Route::post('/admin/deletesubcategory',[SubCategoryController::class,'DeleteSubCategory']);
		Route::get('/admin/updatesubcategory/{id}',[SubCategoryController::class,'UpdateSubCategory']);
		Route::post('/admin/updatesubcategory',[SubCategoryController::class,'Save']);

		// Shop Type
		Route::get('/admin/shoptype', [ShopTypeController::class,'AllShopType']);
		Route::get('/admin/addshoptype',[ShopTypeController::class,'AddShopType']);
		Route::post('/admin/addshoptype',[ShopTypeController::class,'AddShopTypeData']);
		Route::post('/admin/deleteshoptype',[ShopTypeController::class,'DeleteShopType']);
		Route::get('/admin/updateshoptype/{id}',[ShopTypeController::class,'UpdateShopType']);
		Route::post('/admin/updateshoptype',[ShopTypeController::class,'Save']);

		// Route banner
		Route::get('/admin/banner', [BannerController::class,'AllBanner']);
		Route::get('/admin/addbanner',[BannerController::class,'AddBanner']);
		Route::post('/admin/addbanner',[BannerController::class,'AddBannerData']);
		Route::post('/admin/deletebanner',[BannerController::class,'DeleteBanner']);
		Route::get('/admin/updatebanner/{id}',[BannerController::class,'UpdateBanner']);
		Route::post('/admin/updatebanner',[BannerController::class,'Save']);

		// Route Services
		Route::get('/admin/services', [ServicesController::class,'AllServices']);
		Route::get('/admin/addservice',[ServicesController::class,'AddService']);
		Route::post('/admin/addservice',[ServicesController::class,'AddServiceData']);
		Route::post('/admin/activeservice',[ServicesController::class,'ActiveService']);
		Route::post('/admin/deactiveservice',[ServicesController::class,'DeactiveService']);
		Route::post('/admin/deleteservice',[ServicesController::class,'DeleteService']);
		Route::get('/admin/updateservice/{id}',[ServicesController::class,'UpdateService']);
		Route::post('/admin/updateservice',[ServicesController::class,'Save']);
		Route::get('/admin/viewservice/{id}',[ServicesController::class,'ViewService']);

		// Route Information
		Route::get('/admin/information', [InformationController::class,'AllInformation']);
		Route::get('/admin/addinformation',[InformationController::class,'AddInformation']);
		Route::post('/admin/addinformation',[InformationController::class,'AddInformationData']);
		Route::post('/admin/activeinformation',[InformationController::class,'ActiveInformation']);
		Route::post('/admin/deactiveinformation',[InformationController::class,'DeactiveInformation']);
		Route::post('/admin/deleteinformation',[InformationController::class,'DeleteInformation']);
		Route::get('/admin/updateinformation/{id}',[InformationController::class,'UpdateInformation']);
		Route::post('/admin/updateinformation',[InformationController::class,'Save']);
		Route::get('/admin/viewinformation/{id}',[InformationController::class,'ViewInformation']);

		// Route Policy
		Route::get('/admin/policy/{id}',[PolicyController::class,'ViewPolicy']);
		Route::post('/admin/updatepolicy',[PolicyController::class,'Save']);

		// Route Services Request
		Route::get('/admin/servicerequest', [ServiceRequestController::class,'AllServiceRequest']);
		Route::get('/admin/todayservicerequest', [ServiceRequestController::class,'TodayServiceRequest']);
		Route::get('/admin/assignedservicerequest', [ServiceRequestController::class,'AssignedServiceRequest']);
		Route::get('/admin/unassignedservicerequest', [ServiceRequestController::class,'UnassignedServiceRequest']);
		Route::post('/admin/deleteservicerequest',[ServiceRequestController::class,'DeleteServiceRequest']);
		Route::get('/admin/assignexpert/{id}',[ServiceRequestController::class,'AssignExpert']);
		Route::post('/admin/assignexpert',[ServiceRequestController::class,'AssignExpertData']);


		// Route News
		Route::get('/admin/news', [NewsController::class,'AllNews']);
		Route::get('/admin/addnews',[NewsController::class,'AddNews']);
		Route::post('/admin/addnews',[NewsController::class,'AddNewsData']);
		Route::post('/admin/activesnews',[NewsController::class,'ActiveNews']);
		Route::post('/admin/deactivenews',[NewsController::class,'DeactiveNews']);
		Route::post('/admin/deletenews',[NewsController::class,'DeleteNews']);
		Route::get('/admin/updatenews/{id}',[NewsController::class,'UpdateNews']);
		Route::post('/admin/updatenews',[NewsController::class,'Save']);
		Route::get('/admin/viewnews/{id}',[NewsController::class,'ViewNews']);

		//Logout
		Route::get('/admin/logout',[AdminController::class,'Logout']);
	});
