<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Contracts\Encryption\DecryptException;
use Facade\Ignition\Exceptions\ViewException;
use Session;
use Crypt;

use App\Models\AdminLogin;

class AdminController extends Controller
{
    public function index()
    {
        return view('admin.index');
    }

    function login(Request $req)
    {
    	$matchThese = ['user_name' => $req->input('username'), 'type' => $req->input('type')];
    	$user = AdminLogin::where($matchThese)->get();
        $user_count = AdminLogin::where($matchThese)->count();

    	if($user_count == '1' && Crypt::decrypt($user[0]->password)==$req->input('password'))
    	{
   			$req->session()->put('id',$user[0]->id);
   			$req->session()->put('name',$user[0]->name);
			$req->session()->put('photo',$user[0]->img);
   			return redirect(url('/admin/dashboard'));
    	}

    	$req->session()->flash('error', 'Invalid email or password!');
    	return redirect()
    			->back()
    			->withInput();
    }

    public function dashboard()
    {
		if(!session()->has('id'))
		{ return redirect('/panel');}
        return view('admin.dashboard');
    }

	
	// Update Profile
    function Profile($id)
	{
		$page_title = 'Profile';
		$data = AdminLogin::find($id);
		return view('admin.profile',['data'=>$data]);
	}

	function Save(Request $req)
	{
		if(!empty(request()->photo))
		{			
			request()->validate([
			'photo' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
			]);

			$imageName = time().'.'.request()->photo->getClientOriginalExtension();
			request()->photo->move(public_path('images'), $imageName);			
			unlink(public_path('images/'.session()->get('photo')));
			$req->session()->put('photo',$imageName);
		}

 		$admin_tbl = AdminLogin::find($req->id);
		$admin_tbl->name=$req->name;
		$admin_tbl->mobile=$req->mobile;
 		$admin_tbl->email=$req->email;
 		$admin_tbl->address=$req->address;
 		if(!empty($imageName)){ $admin_tbl->img=$imageName; }
		$admin_tbl->save();
		$req->session()->put('name',$req->name);
		$req->session()->flash('success','Update successfully');
		return redirect('/admin/profile/'.$req->id);    	
	}




	// Logout
    function Logout()
	{
		session()->forget('id');
		session()->forget('name');
		session()->forget('error');
		return redirect('/panel');
	}
}
