@extends('admin.layouts.app')

@section('content')
    <section id="main-wrapper" class="theme-dark-full">
        <header id="header">
            <!--logo start-->
            <div class="brand">
                <a href="{{ url('/admin/dashboard') }}" class="logo">
                    <span>{{ Session::get('name') }}</span>
				</a>
            </div>
            <!--logo end-->
            <ul class="nav navbar-nav navbar-left">
                <li class="toggle-navigation toggle-left">
                    <button class="sidebar-toggle" id="toggle-left">
                        <i class="fa fa-bars"></i>
                    </button>
                </li>
            </ul>
            <ul class="nav navbar-nav navbar-right">
                <li class="dropdown profile hidden-xs">
                    <a href="javascript:void(0);" class="dropdown-toggle" data-toggle="dropdown">
                        <span class="meta">
                            <span class="avatar">
                                <img src="{{ URL::to('/') }}/images/{{ Session::get('photo') }}" class="img-circle" alt="">
                            </span>
                        <span class="text">{{ Session::get('name') }}</span>
                        <span class="caret"></span>
                        </span>
                    </a>
                    <ul class="dropdown-menu animated fadeInRight" role="menu">
                        <li>
                            <a href="{{url('/admin/profile')}}/{{ Session::get('id') }}">
                                <span class="icon"><i class="fa fa-user"></i>
                                </span>Profile</a>
                        </li>
                        <li class="divider"></li>
                        <li>
                            <a href="{{url('logout')}}">
                                <span class="icon"><i class="fa fa-sign-out"></i>
                                </span>Logout</a>
                        </li>
                    </ul>
                </li>
                <li class="toggle-fullscreen hidden-xs">
                    <button type="button" class="btn btn-default expand" id="toggle-fullscreen">
                        <i class="fa fa-expand"></i>
                    </button>
                </li>
            </ul>
        </header>
        <!--sidebar left start-->
        <aside class="sidebar sidebar-left">
            <div class="sidebar-profile">
                <div class="avatar">
                    <img src="{{ URL::to('/') }}/images/{{ Session::get('photo') }}" class="img-circle" alt="">
                    <i class="on border-dark animated bounceIn"></i>
                </div>
                <div class="profile-body dropdown">
                    <a href="javascript:void(0);" class="dropdown-toggle"><h4>{{ Session::get('name') }}</h4></a>
                    <small class="title">Superadmin</small>
                </div>
            </div>
            <nav>
                <h5 class="sidebar-header">Navigation</h5>
                <ul class="nav nav-pills nav-stacked">
                    <li>
                        <a href="{{ url('/admin/dashboard') }}" title="Dashboard">
                            <i class="fa  fa-fw fa-tachometer"></i> Dashboard
                        </a>
                    </li>
                    <li class="nav-dropdown">
                        <a href="#" title="UI Elements">
                            <i class="fa  fa-fw fa-user"></i> Users
                        </a>
                        <ul class="nav-sub">
                            <li>
                                <a href="{{ url('/admin/kishan') }}" title="Kishan">
                                     Kishan
                                </a>
                            </li>
                            <li class="active">
                                <a href="{{ url('/admin/vender') }}" title="Vender">
                                     Vender
                                </a>
                            </li>
                            <li>
                                <a href="{{ url('/admin/buyer') }}" title="Buyer">
                                     Buyer
                                </a>
                            </li>
                        </ul>
                    </li>
                    <li class=" open active">
                        <a href="{{url('/admin/category')}}" title="Category">
                            <i class="fa fa-fw fa-th-large "></i> Category
                        </a>
                    </li>
                    <li >
                        <a href="{{url('/admin/sub-category')}}" title="Sub Category">
                            <i class="fa fa-fw fa-th-large "></i> Sub Category
                        </a>
                    </li>
                    <li >
                        <a href="{{url('logout')}}" title="Logout">
                            <i class="fa fa-fw fa-sign-out"></i> Logout
                        </a>
                    </li>
                </ul>
            </nav>
        </aside>
        <!--sidebar left end-->
        <!--main content start-->
        <section class="main-content-wrapper">
            <div class="pageheader dark">
                <h1>Category</h1>
                <div class="breadcrumb-wrapper hidden-xs">
                    <ol class="breadcrumb">
                        <li><a href="{{url('addcategory')}}" class="cusotm-btn">Add Category</a></li>
                    </ol>
                </div>
            </div>
            <section id="main-content" class="animated fadeInUp">
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-default">
                            <div class="panel-body">

								@if (Session::get('success')) 
									<div class="alert alert-success alert-dismissable">
										<button type="button" class="close" data-dismiss="alert" aria-hidden="true">x</button>
										{{ Session::get('success') }}                                    
									</div>
								@endif

                                <table id="example" class="table table-striped table-bordered" cellspacing="0" width="100%">
                                    <thead>
                                        <tr>
                                            <th width="3%">#</th>
                                            <th width="25%">Category</th>
                                            <th>Description</th>
                                            <th width="10%;" class="text-center">Image</th>
                                            <th width="5%" class="text-center">Order</th>
                                            <th width="8%" class="text-center">Status</th>
                                            <th width="10%">Action</th>
                                        </tr>
                                    </thead>

                                    <tbody>									
									@foreach($data as $key => $item)
                                        <tr>
                                            <td><b>{{ ++$key }}.</b></td>
                                            <td>{{ $item->categoryName }}</td>
                                            <td>{!! $item->categoryDescription !!}</td>
                                            <td class="text-center"><img src="{{ URL::to('/') }}/images/category/{{ $item->categoryImage }}" width="90%;"/></td>
                                            <td class="text-center">{{ $item->orderBy }}</td>
                                            <td class="text-center @if($item->flag == '1') green-btn @else red-btn @endif">@if($item->flag == '1') Active @else Deactive @endif</td>
                                            <td>
                                                <form method="post" action="{{url('activecategory')}}">
                                                    @csrf
                                                    <input type="hidden" value="{{$item->categoryID}}" name="id">
                                                    <button type="submit" class="action-btn"><i class="fa fa-check green-btn" title="Active"></i></button>
                                                </form>
                                                <form method="post" action="{{url('deactivecategory')}}">
                                                    @csrf
                                                    <input type="hidden" value="{{$item->categoryID}}" name="id">
                                                    <button type="submit" class="action-btn"><i class="fa fa-close red-btn" title="Deactive"></i></button>
                                                </form>
                                                <a href="{{url('updatecategory')}}/{{$item->categoryID}}" class="action-btn"><i class="fa fa-pencil-square-o blue-btn" title="Edit"></i></a>
                                                <form method="post" action="{{url('deletecategory')}}">
                                                    @csrf
                                                    <input type="hidden" value="{{$item->categoryID}}" name="id">
                                                    <button type="submit" class="action-btn"><i class="fa fa-trash red-btn" title="Delete"></i></button>
                                                </form>
											</td>
                                        </tr>
									@endforeach
                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </section>
        <!--main content end-->
    </section>
    <!--sidebar right start-->
    <aside id="sidebar-right">
        <h4 class="sidebar-title">Contacts</h4>
        <div id="contact-list-wrapper">
            <div class="heading">
                <ul>
                    <li class="new-contact"><a href="javascript:void(0)"><i class="fa fa-plus"></i></a>
                    </li>
                    <li>
                        <input type="text" class="search" placeholder="Search">
                        <button type="submit" class="btn btn-sm btn-search"><i class="fa fa-search"></i>
                        </button>
                    </li>
                </ul>
            </div>
            <div id="contact-list">
                <ul>
                    <li>
                        <div class="row">
                            <div class="col-md-3">
                                <span class="avatar">
                        <img src="http://placehold.it/160x160" class="img-circle" alt="">
                          <i class="on animated bounceIn"></i>
                        </span>
                            </div>
                            <div class="col-md-9">
                                <div class="name">Sara Ellis </div>
                                <small class="location text-muted">IT Analyst</small>
                            </div>
                        </div>
                    </li>
                    <li>
                        <div class="row">
                            <div class="col-md-3">
                                <span class="avatar">
                        <img src="http://placehold.it/160x160" class="img-circle" alt="">
                          <i class="on animated bounceIn"></i>
                        </span>
                            </div>
                            <div class="col-md-9">
                                <div class="name">Peter Holmes </div>
                                <small class="location text-muted"><i class="icon-support"></i> Support</small>
                            </div>
                        </div>
                    </li>
                    <li>
                        <div class="row">
                            <div class="col-md-3">
                                <span class="avatar">
                        <img src="http://placehold.it/160x160" class="img-circle" alt="">
                          <i class="on animated bounceIn"></i>
                        </span>
                            </div>
                            <div class="col-md-9">
                                <div class="name">David Palmer </div>
                                <small class="location text-muted">IT Coordinator</small>
                            </div>
                        </div>
                    </li>
                    <li>
                        <div class="row">
                            <div class="col-md-3">
                                <span class="avatar">
                        <img src="http://placehold.it/160x160" class="img-circle" alt="">
                          <i class="on animated bounceIn"></i>
                        </span>
                            </div>
                            <div class="col-md-9">
                                <div class="name">Amanda Noren </div>
                                <small class="location text-muted">Network Engineer</small>
                            </div>
                        </div>
                    </li>
                    <li>
                        <div class="row">
                            <div class="col-md-3">
                                <span class="avatar">
                        <img src="http://placehold.it/160x160" class="img-circle" alt="">
                          <i class="busy animated bounceIn"></i>
                        </span>
                            </div>
                            <div class="col-md-9">
                                <div class="name off">Steven Baker </div>
                                <small class="location text-muted off">Web Developer</small>
                            </div>
                        </div>
                    </li>
                    <li>
                        <div class="row">
                            <div class="col-md-3">
                                <span class="avatar">
                        <img src="http://placehold.it/160x160" class="img-circle" alt="">
                          <i class="on animated bounceIn"></i>
                        </span>
                            </div>
                            <div class="col-md-9">
                                <div class="name">Frank Littleton</div>
                                <small class="location text-muted"> UX Designer</small>
                            </div>
                        </div>
                    </li>
                    <li>
                        <div class="row">
                            <div class="col-md-3">
                                <span class="avatar">
                        <img src="http://placehold.it/160x160" class="img-circle" alt="">
                          <i class="on animated bounceIn"></i>
                        </span>
                            </div>
                            <div class="col-md-9">
                                <div class="name">Jasmin Green </div>
                                <small class="location text-muted">Project Manager</small>
                            </div>
                        </div>
                    </li>
                    <li>
                        <div class="row">
                            <div class="col-md-3">
                                <span class="avatar">
                        <img src="http://placehold.it/160x160" class="img-circle off" alt="">
                          <i class="off animated bounceIn"></i>
                        </span>
                            </div>
                            <div class="col-md-9">
                                <div class="name off">Jason Lowry </div>
                                <small class="location text-muted off">Creative Director</small>
                            </div>
                        </div>
                    </li>
                    <li>
                        <div class="row">
                            <div class="col-md-3">
                                <span class="avatar">
                        <img src="http://placehold.it/160x160" class="img-circle off" alt="">
                          <i class="off animated bounceIn"></i>
                        </span>
                            </div>
                            <div class="col-md-9">
                                <div class="name off">Aarav Chakrabarti</div>
                                <small class="location text-muted off">Software Engineer</small>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>
            <div id="contact-user">
                <div class="chat-user active"><span><i class="icon-bubble"></i></span>
                </div>
                <div class="email-user"><span><i class="icon-envelope-open"></i></span>
                </div>
                <div class="call-user"><span><i class="icon-call-out"></i></span>
                </div>
            </div>
        </div>
    </aside>
    <!--/sidebar right end-->
@endsection     